/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.config.loaders;

import io.cucumber.pro.config.Config;
import io.cucumber.pro.config.RealValue;
import io.cucumber.pro.config.loaders.ConfigLoader;
import io.cucumber.pro.config.loaders.NullConfigLoader;
import io.cucumber.pro.shaded.org.yaml.snakeyaml.Yaml;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;

public class YamlConfigLoader
implements ConfigLoader {
    private static final Yaml YAML = new Yaml();
    private final Map<String, Object> map;

    public YamlConfigLoader(Reader reader) {
        this.map = (Map)YAML.load(reader);
    }

    public static void load(String[] yamlFileNames, Config config) {
        for (String yamlFileName : yamlFileNames) {
            YamlConfigLoader.getConfigLoader(yamlFileName).load(config);
        }
    }

    private static ConfigLoader getConfigLoader(String yamlFileName) {
        File file = new File(yamlFileName);
        if (!file.isFile()) {
            return new NullConfigLoader();
        }
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8"));
            return new YamlConfigLoader(reader);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void load(Config config) {
        this.populate(config, this.map);
    }

    private void populate(Config config, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            key = key.replaceAll("_", "");
            Object value = entry.getValue();
            if (value == null) {
                config.setNull(key);
                continue;
            }
            if (value instanceof String) {
                config.setValue(key, RealValue.fromString((String)value));
                continue;
            }
            if (value instanceof Boolean) {
                config.setValue(key, RealValue.fromBoolean((Boolean)value));
                continue;
            }
            if (value instanceof Integer) {
                config.setValue(key, RealValue.fromInteger((Integer)value));
                continue;
            }
            if (value instanceof Map) {
                Config childConfig = new Config();
                config.setConfig(key, childConfig);
                this.populate(childConfig, (Map)value);
                continue;
            }
            throw new RuntimeException(String.format("Unsupported YAML type: %s (%s)", value, value.getClass()));
        }
    }
}

