/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.config;

import io.cucumber.pro.config.Value;

public class RealValue
implements Value {
    private String value;

    public RealValue(String value) {
        if (value == null) {
            throw new NullPointerException("value cannot be null");
        }
        this.value = value;
    }

    public static Value fromString(String value) {
        return new RealValue(value);
    }

    public static Value fromInteger(int value) {
        return new RealValue(Integer.toString(value));
    }

    public static Value fromBoolean(boolean value) {
        return new RealValue(Boolean.toString(value));
    }

    @Override
    public String getString() {
        return this.value;
    }

    @Override
    public Boolean getBoolean() {
        return !this.value.matches("false|no|off");
    }

    @Override
    public Integer getInt() {
        return Integer.parseInt(this.value);
    }

    @Override
    public boolean isNull() {
        return false;
    }
}

