/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro;

import io.cucumber.pro.config.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

class FilteredEnv {
    private final Pattern maskPattern;
    private final Map<String, String> env;

    FilteredEnv(Map<String, String> env, Config config) {
        String mask = config.getString("cucumberpro.envmask");
        this.maskPattern = Pattern.compile(String.format(".*(%s).*", mask), 2);
        this.env = env;
    }

    private Map<String, String> clean() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.env.entrySet()) {
            if (this.maskPattern.matcher(entry.getKey()).matches()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public String toString() {
        StringBuilder envb = new StringBuilder();
        Map<String, String> clean = this.clean();
        ArrayList<String> sortedKeys = new ArrayList<String>(clean.keySet());
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            envb.append(key).append("=").append(clean.get(key)).append("\n");
        }
        return envb.toString();
    }
}

