/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.util.io;

import io.cucumber.pro.shaded.org.eclipse.jgit.attributes.Attributes;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.CoreConfig;
import io.cucumber.pro.shaded.org.eclipse.jgit.treewalk.TreeWalk;
import io.cucumber.pro.shaded.org.eclipse.jgit.treewalk.WorkingTreeOptions;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.io.AutoCRLFInputStream;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.io.AutoCRLFOutputStream;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.io.AutoLFInputStream;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.io.AutoLFOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public final class EolStreamTypeUtil {
    private static final boolean FORCE_EOL_LF_ON_CHECKOUT = false;

    private EolStreamTypeUtil() {
    }

    public static CoreConfig.EolStreamType detectStreamType(TreeWalk.OperationType op, WorkingTreeOptions options, Attributes attrs) {
        switch (op) {
            case CHECKIN_OP: {
                return EolStreamTypeUtil.checkInStreamType(options, attrs);
            }
            case CHECKOUT_OP: {
                return EolStreamTypeUtil.checkOutStreamType(options, attrs);
            }
        }
        throw new IllegalArgumentException("unknown OperationType " + (Object)((Object)op));
    }

    public static InputStream wrapInputStream(InputStream in, CoreConfig.EolStreamType conversion) {
        switch (conversion) {
            case TEXT_CRLF: {
                return new AutoCRLFInputStream(in, false);
            }
            case TEXT_LF: {
                return new AutoLFInputStream(in, false);
            }
            case AUTO_CRLF: {
                return new AutoCRLFInputStream(in, true);
            }
            case AUTO_LF: {
                return new AutoLFInputStream(in, true);
            }
        }
        return in;
    }

    public static OutputStream wrapOutputStream(OutputStream out, CoreConfig.EolStreamType conversion) {
        switch (conversion) {
            case TEXT_CRLF: {
                return new AutoCRLFOutputStream(out, false);
            }
            case AUTO_CRLF: {
                return new AutoCRLFOutputStream(out, true);
            }
            case TEXT_LF: {
                return new AutoLFOutputStream(out, false);
            }
            case AUTO_LF: {
                return new AutoLFOutputStream(out, true);
            }
        }
        return out;
    }

    private static CoreConfig.EolStreamType checkInStreamType(WorkingTreeOptions options, Attributes attrs) {
        if (attrs.isUnset("text")) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        if (attrs.isSet("crlf")) {
            return CoreConfig.EolStreamType.TEXT_LF;
        }
        if (attrs.isUnset("crlf")) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        if ("input".equals(attrs.getValue("crlf"))) {
            return CoreConfig.EolStreamType.TEXT_LF;
        }
        String eol = attrs.getValue("eol");
        if (eol != null) {
            return CoreConfig.EolStreamType.TEXT_LF;
        }
        if (attrs.isSet("text")) {
            return CoreConfig.EolStreamType.TEXT_LF;
        }
        if ("auto".equals(attrs.getValue("text"))) {
            return CoreConfig.EolStreamType.AUTO_LF;
        }
        switch (options.getAutoCRLF()) {
            case TRUE: 
            case INPUT: {
                return CoreConfig.EolStreamType.AUTO_LF;
            }
            case FALSE: {
                return CoreConfig.EolStreamType.DIRECT;
            }
        }
        return CoreConfig.EolStreamType.DIRECT;
    }

    private static CoreConfig.EolStreamType checkOutStreamType(WorkingTreeOptions options, Attributes attrs) {
        if (attrs.isUnset("text")) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        if (attrs.isSet("crlf")) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        if (attrs.isUnset("crlf")) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        if ("input".equals(attrs.getValue("crlf"))) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        String eol = attrs.getValue("eol");
        if (eol != null && "crlf".equals(eol)) {
            return CoreConfig.EolStreamType.TEXT_CRLF;
        }
        if (eol != null && "lf".equals(eol)) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        if (attrs.isSet("text")) {
            switch (options.getAutoCRLF()) {
                case TRUE: {
                    return CoreConfig.EolStreamType.TEXT_CRLF;
                }
            }
            switch (options.getEOL()) {
                case CRLF: {
                    return CoreConfig.EolStreamType.TEXT_CRLF;
                }
                case LF: {
                    return CoreConfig.EolStreamType.DIRECT;
                }
            }
            return CoreConfig.EolStreamType.DIRECT;
        }
        if ("auto".equals(attrs.getValue("text"))) {
            switch (options.getAutoCRLF()) {
                case TRUE: {
                    return CoreConfig.EolStreamType.AUTO_CRLF;
                }
            }
            switch (options.getEOL()) {
                case CRLF: {
                    return CoreConfig.EolStreamType.AUTO_CRLF;
                }
                case LF: {
                    return CoreConfig.EolStreamType.DIRECT;
                }
            }
            return CoreConfig.EolStreamType.DIRECT;
        }
        switch (options.getAutoCRLF()) {
            case TRUE: {
                return CoreConfig.EolStreamType.AUTO_CRLF;
            }
        }
        return CoreConfig.EolStreamType.DIRECT;
    }
}

