/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.transport;

import io.cucumber.pro.shaded.org.eclipse.jgit.errors.NotSupportedException;
import io.cucumber.pro.shaded.org.eclipse.jgit.errors.TransportException;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.JGitText;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.BundleFetchConnection;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.FetchConnection;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.PushConnection;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.Transport;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.TransportBundle;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.URIish;
import java.io.IOException;
import java.io.InputStream;

public class TransportBundleStream
extends Transport
implements TransportBundle {
    private InputStream src;

    public TransportBundleStream(Repository db, URIish uri, InputStream in) {
        super(db, uri);
        this.src = in;
    }

    @Override
    public FetchConnection openFetch() throws TransportException {
        if (this.src == null) {
            throw new TransportException(this.uri, JGitText.get().onlyOneFetchSupported);
        }
        try {
            BundleFetchConnection bundleFetchConnection = new BundleFetchConnection(this, this.src);
            return bundleFetchConnection;
        }
        finally {
            this.src = null;
        }
    }

    @Override
    public PushConnection openPush() throws NotSupportedException {
        throw new NotSupportedException(JGitText.get().pushIsNotSupportedForBundleTransport);
    }

    @Override
    public void close() {
        if (this.src != null) {
            try {
                this.src.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.src = null;
            }
        }
    }
}

