/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.revwalk;

import io.cucumber.pro.shaded.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import io.cucumber.pro.shaded.org.eclipse.jgit.errors.MissingObjectException;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.AnyObjectId;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectReader;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevCommit;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevFlag;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevObject;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevTag;
import java.io.IOException;

public interface DepthWalk {
    public int getDepth();

    public RevFlag getUnshallowFlag();

    public RevFlag getReinterestingFlag();

    public static class Commit
    extends RevCommit {
        int depth = -1;

        public int getDepth() {
            return this.depth;
        }

        protected Commit(AnyObjectId id) {
            super(id);
        }
    }

    public static class ObjectWalk
    extends io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.ObjectWalk
    implements DepthWalk {
        private final int depth;
        private final RevFlag UNSHALLOW;
        private final RevFlag REINTERESTING;

        public ObjectWalk(Repository repo, int depth) {
            super(repo);
            this.depth = depth;
            this.UNSHALLOW = this.newFlag("UNSHALLOW");
            this.REINTERESTING = this.newFlag("REINTERESTING");
        }

        public ObjectWalk(ObjectReader or, int depth) {
            super(or);
            this.depth = depth;
            this.UNSHALLOW = this.newFlag("UNSHALLOW");
            this.REINTERESTING = this.newFlag("REINTERESTING");
        }

        public void markRoot(RevObject o) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            RevObject c = o;
            while (c instanceof RevTag) {
                c = ((RevTag)c).getObject();
                this.parseHeaders(c);
            }
            if (c instanceof Commit) {
                ((Commit)c).depth = 0;
            }
            super.markStart(o);
        }

        public void markUnshallow(RevObject c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            if (c instanceof RevCommit) {
                c.add(this.UNSHALLOW);
            }
            super.markStart(c);
        }

        @Override
        protected RevCommit createCommit(AnyObjectId id) {
            return new Commit(id);
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public RevFlag getUnshallowFlag() {
            return this.UNSHALLOW;
        }

        @Override
        public RevFlag getReinterestingFlag() {
            return this.REINTERESTING;
        }
    }

    public static class RevWalk
    extends io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevWalk
    implements DepthWalk {
        private final int depth;
        private final RevFlag UNSHALLOW;
        private final RevFlag REINTERESTING;

        public RevWalk(Repository repo, int depth) {
            super(repo);
            this.depth = depth;
            this.UNSHALLOW = this.newFlag("UNSHALLOW");
            this.REINTERESTING = this.newFlag("REINTERESTING");
        }

        public RevWalk(ObjectReader or, int depth) {
            super(or);
            this.depth = depth;
            this.UNSHALLOW = this.newFlag("UNSHALLOW");
            this.REINTERESTING = this.newFlag("REINTERESTING");
        }

        public void markRoot(RevCommit c) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            if (c instanceof Commit) {
                ((Commit)c).depth = 0;
            }
            super.markStart(c);
        }

        @Override
        protected RevCommit createCommit(AnyObjectId id) {
            return new Commit(id);
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        public RevFlag getUnshallowFlag() {
            return this.UNSHALLOW;
        }

        @Override
        public RevFlag getReinterestingFlag() {
            return this.REINTERESTING;
        }

        @Override
        public ObjectWalk toObjectWalkWithSameObjects() {
            ObjectWalk ow = new ObjectWalk(this.reader, this.depth);
            ow.objects = this.objects;
            ow.freeFlags = this.freeFlags;
            return ow;
        }
    }
}

