/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.patch;

import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Constants;
import io.cucumber.pro.shaded.org.eclipse.jgit.patch.FileHeader;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.RawParseUtils;

public class BinaryHunk {
    private static final byte[] LITERAL = Constants.encodeASCII("literal ");
    private static final byte[] DELTA = Constants.encodeASCII("delta ");
    private final FileHeader file;
    final int startOffset;
    int endOffset;
    private Type type;
    private int length;

    BinaryHunk(FileHeader fh, int offset) {
        this.file = fh;
        this.startOffset = offset;
    }

    public FileHeader getFileHeader() {
        return this.file;
    }

    public byte[] getBuffer() {
        return this.file.buf;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public Type getType() {
        return this.type;
    }

    public int getSize() {
        return this.length;
    }

    int parseHunk(int ptr, int end) {
        byte[] buf = this.file.buf;
        if (RawParseUtils.match(buf, ptr, LITERAL) >= 0) {
            this.type = Type.LITERAL_DEFLATED;
            this.length = RawParseUtils.parseBase10(buf, ptr + LITERAL.length, null);
        } else if (RawParseUtils.match(buf, ptr, DELTA) >= 0) {
            this.type = Type.DELTA_DEFLATED;
            this.length = RawParseUtils.parseBase10(buf, ptr + DELTA.length, null);
        } else {
            return -1;
        }
        ptr = RawParseUtils.nextLF(buf, ptr);
        while (ptr < end) {
            boolean empty = buf[ptr] == 10;
            ptr = RawParseUtils.nextLF(buf, ptr);
            if (!empty) continue;
            break;
        }
        return ptr;
    }

    public static enum Type {
        LITERAL_DEFLATED,
        DELTA_DEFLATED;

    }
}

