/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file;

import io.cucumber.pro.shaded.org.eclipse.jgit.util.IO;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.NB;
import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;

class SimpleDataInput
implements DataInput {
    private final InputStream fd;
    private final byte[] buf = new byte[8];

    SimpleDataInput(InputStream fd) {
        this.fd = fd;
    }

    @Override
    public int readInt() throws IOException {
        this.readFully(this.buf, 0, 4);
        return NB.decodeInt32(this.buf, 0);
    }

    @Override
    public long readLong() throws IOException {
        this.readFully(this.buf, 0, 8);
        return NB.decodeInt64(this.buf, 0);
    }

    public long readUnsignedInt() throws IOException {
        this.readFully(this.buf, 0, 4);
        return NB.decodeUInt32(this.buf, 0);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        IO.readFully(this.fd, b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean readBoolean() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte readByte() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short readShort() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public char readChar() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public float readFloat() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double readDouble() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }
}

