/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file;

import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file.PackFile;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.file.WindowCursor;
import java.io.IOException;
import java.io.InputStream;

class PackInputStream
extends InputStream {
    private final WindowCursor wc;
    private final PackFile pack;
    private long pos;

    PackInputStream(PackFile pack, long pos, WindowCursor wc) throws IOException {
        this.pack = pack;
        this.pos = pos;
        this.wc = wc;
        wc.pin(pack, pos);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.wc.copy(this.pack, this.pos, b, off, len);
        this.pos += (long)n;
        return n;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int n = this.read(buf, 0, 1);
        return n == 1 ? buf[0] & 0xFF : -1;
    }

    @Override
    public void close() {
        this.wc.close();
    }
}

