/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.blame;

import io.cucumber.pro.shaded.org.eclipse.jgit.errors.IncorrectObjectTypeException;
import io.cucumber.pro.shaded.org.eclipse.jgit.errors.MissingObjectException;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.AnyObjectId;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevCommit;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevWalk;
import java.io.IOException;

final class ReverseWalk
extends RevWalk {
    ReverseWalk(Repository repo) {
        super(repo);
    }

    @Override
    public ReverseCommit next() throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ReverseCommit c = (ReverseCommit)super.next();
        if (c == null) {
            return null;
        }
        for (int pIdx = 0; pIdx < c.getParentCount(); ++pIdx) {
            ((ReverseCommit)c.getParent(pIdx)).addChild(c);
        }
        return c;
    }

    @Override
    protected RevCommit createCommit(AnyObjectId id) {
        return new ReverseCommit(id);
    }

    static final class ReverseCommit
    extends RevCommit {
        private static final ReverseCommit[] NO_CHILDREN = new ReverseCommit[0];
        private ReverseCommit[] children = NO_CHILDREN;

        ReverseCommit(AnyObjectId id) {
            super(id);
        }

        void addChild(ReverseCommit c) {
            int cnt = this.children.length;
            if (cnt == 0) {
                this.children = new ReverseCommit[]{c};
            } else if (cnt == 1) {
                this.children = new ReverseCommit[]{c, this.children[0]};
            } else {
                ReverseCommit[] n = new ReverseCommit[1 + cnt];
                n[0] = c;
                System.arraycopy(this.children, 0, n, 1, cnt);
                this.children = n;
            }
        }

        int getChildCount() {
            return this.children.length;
        }

        ReverseCommit getChild(int nth) {
            return this.children[nth];
        }
    }
}

