/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.api;

import io.cucumber.pro.shaded.org.eclipse.jgit.api.GitCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.GitAPIException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.JGitInternalException;
import io.cucumber.pro.shaded.org.eclipse.jgit.errors.ConfigInvalidException;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.StoredConfig;
import io.cucumber.pro.shaded.org.eclipse.jgit.submodule.SubmoduleWalk;
import io.cucumber.pro.shaded.org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class SubmoduleInitCommand
extends GitCommand<Collection<String>> {
    private final Collection<String> paths = new ArrayList<String>();

    public SubmoduleInitCommand(Repository repo) {
        super(repo);
    }

    public SubmoduleInitCommand addPath(String path) {
        this.paths.add(path);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> call() throws GitAPIException {
        this.checkCallable();
        try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            StoredConfig config = this.repo.getConfig();
            ArrayList<String> initialized = new ArrayList<String>();
            while (generator.next()) {
                if (generator.getConfigUrl() != null) continue;
                String path = generator.getPath();
                String url = generator.getRemoteUrl();
                String update = generator.getModulesUpdate();
                if (url != null) {
                    config.setString("submodule", path, "url", url);
                }
                if (update != null) {
                    config.setString("submodule", path, "update", update);
                }
                if (url == null && update == null) continue;
                initialized.add(path);
            }
            if (!initialized.isEmpty()) {
                config.save();
            }
            ArrayList<String> arrayList = initialized;
            return arrayList;
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (ConfigInvalidException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }
}

