/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.api;

import io.cucumber.pro.shaded.org.eclipse.jgit.api.CheckoutCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.CherryPickCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.CherryPickResult;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.CommitCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.Git;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.GitCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.LogCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.MergeCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.MergeResult;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.RebaseResult;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.ResetCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.Status;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.CheckoutConflictException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.GitAPIException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.InvalidRebaseStepException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.InvalidRefNameException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.JGitInternalException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.NoHeadException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.NoMessageException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.RefAlreadyExistsException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.RefNotFoundException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.StashApplyFailureException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.UnmergedPathsException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import io.cucumber.pro.shaded.org.eclipse.jgit.diff.DiffFormatter;
import io.cucumber.pro.shaded.org.eclipse.jgit.dircache.DirCache;
import io.cucumber.pro.shaded.org.eclipse.jgit.dircache.DirCacheCheckout;
import io.cucumber.pro.shaded.org.eclipse.jgit.dircache.DirCacheIterator;
import io.cucumber.pro.shaded.org.eclipse.jgit.errors.RevisionSyntaxException;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.JGitText;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.AbbreviatedObjectId;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.AnyObjectId;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.NullProgressMonitor;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectId;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectReader;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.PersonIdent;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ProgressMonitor;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.RebaseTodoLine;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Ref;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.RefUpdate;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.merge.MergeStrategy;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevCommit;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevWalk;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.filter.RevFilter;
import io.cucumber.pro.shaded.org.eclipse.jgit.submodule.SubmoduleWalk;
import io.cucumber.pro.shaded.org.eclipse.jgit.treewalk.TreeWalk;
import io.cucumber.pro.shaded.org.eclipse.jgit.treewalk.filter.TreeFilter;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.FileUtils;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.IO;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.RawParseUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RebaseCommand
extends GitCommand<RebaseResult> {
    public static final String REBASE_MERGE = "rebase-merge";
    private static final String REBASE_APPLY = "rebase-apply";
    public static final String STOPPED_SHA = "stopped-sha";
    private static final String AUTHOR_SCRIPT = "author-script";
    private static final String DONE = "done";
    private static final String GIT_AUTHOR_DATE = "GIT_AUTHOR_DATE";
    private static final String GIT_AUTHOR_EMAIL = "GIT_AUTHOR_EMAIL";
    private static final String GIT_AUTHOR_NAME = "GIT_AUTHOR_NAME";
    private static final String GIT_REBASE_TODO = "git-rebase-todo";
    private static final String HEAD_NAME = "head-name";
    private static final String INTERACTIVE = "interactive";
    private static final String QUIET = "quiet";
    private static final String MESSAGE = "message";
    private static final String ONTO = "onto";
    private static final String ONTO_NAME = "onto-name";
    private static final String PATCH = "patch";
    private static final String REBASE_HEAD = "head";
    private static final String AMEND = "amend";
    private static final String MESSAGE_FIXUP = "message-fixup";
    private static final String MESSAGE_SQUASH = "message-squash";
    private static final String AUTOSTASH = "autostash";
    private static final String AUTOSTASH_MSG = "On {0}: autostash";
    private static final String REWRITTEN = "rewritten";
    private static final String CURRENT_COMMIT = "current-commit";
    private static final String REFLOG_PREFIX = "rebase:";
    private Operation operation = Operation.BEGIN;
    private RevCommit upstreamCommit;
    private String upstreamCommitName;
    private ProgressMonitor monitor = NullProgressMonitor.INSTANCE;
    private final RevWalk walk;
    private final RebaseState rebaseState;
    private InteractiveHandler interactiveHandler;
    private boolean stopAfterInitialization = false;
    private RevCommit newHead;
    private boolean lastStepWasForward;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private boolean preserveMerges = false;

    protected RebaseCommand(Repository repo) {
        super(repo);
        this.walk = new RevWalk(repo);
        this.rebaseState = new RebaseState(repo.getDirectory());
    }

    @Override
    public RebaseResult call() throws GitAPIException, NoHeadException, RefNotFoundException, WrongRepositoryStateException {
        this.newHead = null;
        this.lastStepWasForward = false;
        this.checkCallable();
        this.checkParameters();
        try {
            List<RebaseTodoLine> steps;
            switch (this.operation) {
                case ABORT: {
                    try {
                        return this.abort(RebaseResult.ABORTED_RESULT);
                    }
                    catch (IOException ioe) {
                        throw new JGitInternalException(ioe.getMessage(), ioe);
                    }
                }
                case PROCESS_STEPS: 
                case SKIP: 
                case CONTINUE: {
                    String upstreamCommitId = this.rebaseState.readFile(ONTO);
                    try {
                        this.upstreamCommitName = this.rebaseState.readFile(ONTO_NAME);
                    }
                    catch (FileNotFoundException e) {
                        this.upstreamCommitName = upstreamCommitId;
                    }
                    this.upstreamCommit = this.walk.parseCommit(this.repo.resolve(upstreamCommitId));
                    this.preserveMerges = this.rebaseState.getRewrittenDir().exists();
                    break;
                }
                case BEGIN: {
                    Status status;
                    this.autoStash();
                    if ((this.stopAfterInitialization || !this.walk.isMergedInto(this.walk.parseCommit(this.repo.resolve("HEAD")), this.upstreamCommit)) && (status = Git.wrap(this.repo).status().setIgnoreSubmodules(SubmoduleWalk.IgnoreSubmoduleMode.ALL).call()).hasUncommittedChanges()) {
                        ArrayList<String> list = new ArrayList<String>();
                        list.addAll(status.getUncommittedChanges());
                        return RebaseResult.uncommittedChanges(list);
                    }
                    RebaseResult res = this.initFilesAndRewind();
                    if (this.stopAfterInitialization) {
                        return RebaseResult.INTERACTIVE_PREPARED_RESULT;
                    }
                    if (res == null) break;
                    this.autoStashApply();
                    if (this.rebaseState.getDir().exists()) {
                        FileUtils.delete(this.rebaseState.getDir(), 1);
                    }
                    return res;
                }
            }
            if (this.monitor.isCancelled()) {
                return this.abort(RebaseResult.ABORTED_RESULT);
            }
            if (this.operation == Operation.CONTINUE) {
                RebaseTodoLine newStep;
                RebaseResult result;
                this.newHead = this.continueRebase();
                List<RebaseTodoLine> doneLines = this.repo.readRebaseTodo(this.rebaseState.getPath(DONE), true);
                RebaseTodoLine step = doneLines.get(doneLines.size() - 1);
                if (this.newHead != null && step.getAction() != RebaseTodoLine.Action.PICK && (result = this.processStep(newStep = new RebaseTodoLine(step.getAction(), AbbreviatedObjectId.fromObjectId(this.newHead), step.getShortMessage()), false)) != null) {
                    return result;
                }
                File amendFile = this.rebaseState.getFile(AMEND);
                boolean amendExists = amendFile.exists();
                if (amendExists) {
                    FileUtils.delete(amendFile);
                }
                if (this.newHead == null && !amendExists) {
                    return RebaseResult.NOTHING_TO_COMMIT_RESULT;
                }
            }
            if (this.operation == Operation.SKIP) {
                this.newHead = this.checkoutCurrentHead();
            }
            if ((steps = this.repo.readRebaseTodo(this.rebaseState.getPath(GIT_REBASE_TODO), false)).size() == 0) {
                return this.finishRebase(this.walk.parseCommit(this.repo.resolve("HEAD")), false);
            }
            if (this.isInteractive()) {
                this.interactiveHandler.prepareSteps(steps);
                this.repo.writeRebaseTodoFile(this.rebaseState.getPath(GIT_REBASE_TODO), steps, false);
            }
            this.checkSteps(steps);
            for (int i = 0; i < steps.size(); ++i) {
                RebaseTodoLine step = steps.get(i);
                this.popSteps(1);
                RebaseResult result = this.processStep(step, true);
                if (result == null) continue;
                return result;
            }
            return this.finishRebase(this.newHead, this.lastStepWasForward);
        }
        catch (CheckoutConflictException cce) {
            return RebaseResult.conflicts(cce.getConflictingPaths());
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
    }

    private void autoStash() throws GitAPIException, IOException {
        if (this.repo.getConfig().getBoolean("rebase", AUTOSTASH, false)) {
            String message = MessageFormat.format(AUTOSTASH_MSG, Repository.shortenRefName(RebaseCommand.getHeadName(this.getHead())));
            RevCommit stashCommit = Git.wrap(this.repo).stashCreate().setRef(null).setWorkingDirectoryMessage(message).call();
            if (stashCommit != null) {
                FileUtils.mkdir(this.rebaseState.getDir());
                this.rebaseState.createFile(AUTOSTASH, stashCommit.getName());
            }
        }
    }

    private boolean autoStashApply() throws IOException, GitAPIException {
        boolean conflicts = false;
        if (this.rebaseState.getFile(AUTOSTASH).exists()) {
            String stash = this.rebaseState.readFile(AUTOSTASH);
            try (Git git = Git.wrap(this.repo);){
                git.stashApply().setStashRef(stash).ignoreRepositoryState(true).setStrategy(this.strategy).call();
            }
            catch (StashApplyFailureException e) {
                conflicts = true;
                try (RevWalk rw = new RevWalk(this.repo);){
                    ObjectId stashId = this.repo.resolve(stash);
                    RevCommit commit = rw.parseCommit(stashId);
                    this.updateStashRef(commit, commit.getAuthorIdent(), commit.getShortMessage());
                }
            }
        }
        return conflicts;
    }

    private void updateStashRef(ObjectId commitId, PersonIdent refLogIdent, String refLogMessage) throws IOException {
        Ref currentRef = this.repo.exactRef("refs/stash");
        RefUpdate refUpdate = this.repo.updateRef("refs/stash");
        refUpdate.setNewObjectId(commitId);
        refUpdate.setRefLogIdent(refLogIdent);
        refUpdate.setRefLogMessage(refLogMessage, false);
        refUpdate.setForceRefLog(true);
        if (currentRef != null) {
            refUpdate.setExpectedOldObjectId(currentRef.getObjectId());
        } else {
            refUpdate.setExpectedOldObjectId(ObjectId.zeroId());
        }
        refUpdate.forceUpdate();
    }

    private RebaseResult processStep(RebaseTodoLine step, boolean shouldPick) throws IOException, GitAPIException {
        ObjectReader or;
        Collection<ObjectId> ids;
        if (RebaseTodoLine.Action.COMMENT.equals((Object)step.getAction())) {
            return null;
        }
        if (this.preserveMerges && shouldPick && (RebaseTodoLine.Action.EDIT.equals((Object)step.getAction()) || RebaseTodoLine.Action.PICK.equals((Object)step.getAction()))) {
            this.writeRewrittenHashes();
        }
        if ((ids = (or = this.repo.newObjectReader()).resolve(step.getCommit())).size() != 1) {
            throw new JGitInternalException(JGitText.get().cannotResolveUniquelyAbbrevObjectId);
        }
        RevCommit commitToPick = this.walk.parseCommit(ids.iterator().next());
        if (shouldPick) {
            if (this.monitor.isCancelled()) {
                return RebaseResult.result(RebaseResult.Status.STOPPED, commitToPick);
            }
            RebaseResult result = this.cherryPickCommit(commitToPick);
            if (result != null) {
                return result;
            }
        }
        boolean isSquash = false;
        switch (step.getAction()) {
            case PICK: {
                return null;
            }
            case REWORD: {
                String oldMessage = commitToPick.getFullMessage();
                String newMessage = this.interactiveHandler.modifyCommitMessage(oldMessage);
                try (Git git = new Git(this.repo);){
                    this.newHead = git.commit().setMessage(newMessage).setAmend(true).setNoVerify(true).call();
                }
                return null;
            }
            case EDIT: {
                this.rebaseState.createFile(AMEND, commitToPick.name());
                return this.stop(commitToPick, RebaseResult.Status.EDIT);
            }
            case COMMENT: {
                break;
            }
            case SQUASH: {
                isSquash = true;
            }
            case FIXUP: {
                this.resetSoftToParent();
                List<RebaseTodoLine> steps = this.repo.readRebaseTodo(this.rebaseState.getPath(GIT_REBASE_TODO), false);
                RebaseTodoLine nextStep = steps.size() > 0 ? steps.get(0) : null;
                File messageFixupFile = this.rebaseState.getFile(MESSAGE_FIXUP);
                File messageSquashFile = this.rebaseState.getFile(MESSAGE_SQUASH);
                if (isSquash && messageFixupFile.exists()) {
                    messageFixupFile.delete();
                }
                this.newHead = this.doSquashFixup(isSquash, commitToPick, nextStep, messageFixupFile, messageSquashFile);
            }
        }
        return null;
    }

    private RebaseResult cherryPickCommit(RevCommit commitToPick) throws IOException, GitAPIException, NoMessageException, UnmergedPathsException, ConcurrentRefUpdateException, WrongRepositoryStateException, NoHeadException {
        try {
            this.monitor.beginTask(MessageFormat.format(JGitText.get().applyingCommit, commitToPick.getShortMessage()), 0);
            if (this.preserveMerges) {
                RebaseResult rebaseResult = this.cherryPickCommitPreservingMerges(commitToPick);
                return rebaseResult;
            }
            RebaseResult rebaseResult = this.cherryPickCommitFlattening(commitToPick);
            return rebaseResult;
        }
        finally {
            this.monitor.endTask();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RebaseResult cherryPickCommitFlattening(RevCommit commitToPick) throws IOException, GitAPIException, NoMessageException, UnmergedPathsException, ConcurrentRefUpdateException, WrongRepositoryStateException, NoHeadException {
        this.newHead = this.tryFastForward(commitToPick);
        this.lastStepWasForward = this.newHead != null;
        if (this.lastStepWasForward) return null;
        String ourCommitName = this.getOurCommitName();
        try (Git git = new Git(this.repo);){
            CherryPickResult cherryPickResult = git.cherryPick().include(commitToPick).setOurCommitName(ourCommitName).setReflogPrefix(REFLOG_PREFIX).setStrategy(this.strategy).call();
            switch (cherryPickResult.getStatus()) {
                case FAILED: {
                    if (this.operation == Operation.BEGIN) {
                        RebaseResult rebaseResult = this.abort(RebaseResult.failed(cherryPickResult.getFailingPaths()));
                        return rebaseResult;
                    }
                    RebaseResult rebaseResult = this.stop(commitToPick, RebaseResult.Status.STOPPED);
                    return rebaseResult;
                }
                case CONFLICTING: {
                    RebaseResult rebaseResult = this.stop(commitToPick, RebaseResult.Status.STOPPED);
                    return rebaseResult;
                }
                case OK: {
                    this.newHead = cherryPickResult.getNewHead();
                    return null;
                }
            }
            return null;
        }
    }

    private RebaseResult cherryPickCommitPreservingMerges(RevCommit commitToPick) throws IOException, GitAPIException, NoMessageException, UnmergedPathsException, ConcurrentRefUpdateException, WrongRepositoryStateException, NoHeadException {
        block25: {
            this.writeCurrentCommit(commitToPick);
            List<RevCommit> newParents = this.getNewParents(commitToPick);
            boolean otherParentsUnchanged = true;
            for (int i = 1; i < commitToPick.getParentCount(); ++i) {
                otherParentsUnchanged &= newParents.get(i).equals(commitToPick.getParent(i));
            }
            this.newHead = otherParentsUnchanged ? this.tryFastForward(commitToPick) : null;
            boolean bl = this.lastStepWasForward = this.newHead != null;
            if (!this.lastStepWasForward) {
                ObjectId headId = this.getHead().getObjectId();
                assert (headId != null);
                if (!AnyObjectId.equals(headId, newParents.get(0))) {
                    this.checkoutCommit(headId.getName(), newParents.get(0));
                }
                try (Git git = new Git(this.repo);){
                    if (otherParentsUnchanged) {
                        boolean isMerge = commitToPick.getParentCount() > 1;
                        String ourCommitName = this.getOurCommitName();
                        CherryPickCommand pickCommand = git.cherryPick().include(commitToPick).setOurCommitName(ourCommitName).setReflogPrefix(REFLOG_PREFIX).setStrategy(this.strategy);
                        if (isMerge) {
                            pickCommand.setMainlineParentNumber(1);
                            pickCommand.setNoCommit(true);
                            this.writeMergeInfo(commitToPick, newParents);
                        }
                        CherryPickResult cherryPickResult = pickCommand.call();
                        switch (cherryPickResult.getStatus()) {
                            case FAILED: {
                                if (this.operation == Operation.BEGIN) {
                                    RebaseResult rebaseResult = this.abort(RebaseResult.failed(cherryPickResult.getFailingPaths()));
                                    return rebaseResult;
                                }
                                RebaseResult rebaseResult = this.stop(commitToPick, RebaseResult.Status.STOPPED);
                                return rebaseResult;
                            }
                            case CONFLICTING: {
                                RebaseResult rebaseResult = this.stop(commitToPick, RebaseResult.Status.STOPPED);
                                return rebaseResult;
                            }
                            case OK: {
                                if (isMerge) {
                                    CommitCommand commit = git.commit();
                                    commit.setAuthor(commitToPick.getAuthorIdent());
                                    commit.setReflogComment("rebase: " + commitToPick.getShortMessage());
                                    this.newHead = commit.call();
                                    break;
                                }
                                this.newHead = cherryPickResult.getNewHead();
                            }
                        }
                        break block25;
                    }
                    MergeCommand merge = git.merge().setFastForward(MergeCommand.FastForwardMode.NO_FF).setProgressMonitor(this.monitor).setCommit(false);
                    for (int i = 1; i < commitToPick.getParentCount(); ++i) {
                        merge.include(newParents.get(i));
                    }
                    MergeResult mergeResult = merge.call();
                    if (mergeResult.getMergeStatus().isSuccessful()) {
                        CommitCommand commit = git.commit();
                        commit.setAuthor(commitToPick.getAuthorIdent());
                        commit.setMessage(commitToPick.getFullMessage());
                        commit.setReflogComment("rebase: " + commitToPick.getShortMessage());
                        this.newHead = commit.call();
                        break block25;
                    }
                    if (this.operation == Operation.BEGIN && mergeResult.getMergeStatus() == MergeResult.MergeStatus.FAILED) {
                        RebaseResult rebaseResult = this.abort(RebaseResult.failed(mergeResult.getFailingPaths()));
                        return rebaseResult;
                    }
                    RebaseResult rebaseResult = this.stop(commitToPick, RebaseResult.Status.STOPPED);
                    return rebaseResult;
                }
            }
        }
        return null;
    }

    private void writeMergeInfo(RevCommit commitToPick, List<RevCommit> newParents) throws IOException {
        this.repo.writeMergeHeads(newParents.subList(1, newParents.size()));
        this.repo.writeMergeCommitMsg(commitToPick.getFullMessage());
    }

    private List<RevCommit> getNewParents(RevCommit commitToPick) throws IOException {
        ArrayList<RevCommit> newParents = new ArrayList<RevCommit>();
        for (int p = 0; p < commitToPick.getParentCount(); ++p) {
            String parentHash = commitToPick.getParent(p).getName();
            if (!new File(this.rebaseState.getRewrittenDir(), parentHash).exists()) {
                newParents.add(commitToPick.getParent(p));
                continue;
            }
            String newParent = RebaseState.readFile(this.rebaseState.getRewrittenDir(), parentHash);
            if (newParent.length() == 0) {
                newParents.add(this.walk.parseCommit(this.repo.resolve("HEAD")));
                continue;
            }
            newParents.add(this.walk.parseCommit(ObjectId.fromString(newParent)));
        }
        return newParents;
    }

    private void writeCurrentCommit(RevCommit commit) throws IOException {
        RebaseState.appendToFile(this.rebaseState.getFile(CURRENT_COMMIT), commit.name());
    }

    private void writeRewrittenHashes() throws RevisionSyntaxException, IOException, RefNotFoundException {
        File currentCommitFile = this.rebaseState.getFile(CURRENT_COMMIT);
        if (!currentCommitFile.exists()) {
            return;
        }
        ObjectId headId = this.getHead().getObjectId();
        assert (headId != null);
        String head = headId.getName();
        String currentCommits = this.rebaseState.readFile(CURRENT_COMMIT);
        for (String current : currentCommits.split("\n")) {
            RebaseState.createFile(this.rebaseState.getRewrittenDir(), current, head);
        }
        FileUtils.delete(currentCommitFile);
    }

    private RebaseResult finishRebase(RevCommit finalHead, boolean lastStepIsForward) throws IOException, GitAPIException {
        String headName = this.rebaseState.readFile(HEAD_NAME);
        this.updateHead(headName, finalHead, this.upstreamCommit);
        boolean stashConflicts = this.autoStashApply();
        this.getRepository().autoGC(this.monitor);
        FileUtils.delete(this.rebaseState.getDir(), 1);
        if (stashConflicts) {
            return RebaseResult.STASH_APPLY_CONFLICTS_RESULT;
        }
        if (lastStepIsForward || finalHead == null) {
            return RebaseResult.FAST_FORWARD_RESULT;
        }
        return RebaseResult.OK_RESULT;
    }

    private void checkSteps(List<RebaseTodoLine> steps) throws InvalidRebaseStepException, IOException {
        if (steps.isEmpty()) {
            return;
        }
        if (!(!RebaseTodoLine.Action.SQUASH.equals((Object)steps.get(0).getAction()) && !RebaseTodoLine.Action.FIXUP.equals((Object)steps.get(0).getAction()) || this.rebaseState.getFile(DONE).exists() && this.rebaseState.readFile(DONE).trim().length() != 0)) {
            throw new InvalidRebaseStepException(MessageFormat.format(JGitText.get().cannotSquashFixupWithoutPreviousCommit, steps.get(0).getAction().name()));
        }
    }

    private RevCommit doSquashFixup(boolean isSquash, RevCommit commitToPick, RebaseTodoLine nextStep, File messageFixup, File messageSquash) throws IOException, GitAPIException {
        if (!messageSquash.exists()) {
            ObjectId headId = this.repo.resolve("HEAD");
            RevCommit previousCommit = this.walk.parseCommit(headId);
            this.initializeSquashFixupFile(MESSAGE_SQUASH, previousCommit.getFullMessage());
            if (!isSquash) {
                this.initializeSquashFixupFile(MESSAGE_FIXUP, previousCommit.getFullMessage());
            }
        }
        String currSquashMessage = this.rebaseState.readFile(MESSAGE_SQUASH);
        int count = RebaseCommand.parseSquashFixupSequenceCount(currSquashMessage) + 1;
        String content = RebaseCommand.composeSquashMessage(isSquash, commitToPick, currSquashMessage, count);
        this.rebaseState.createFile(MESSAGE_SQUASH, content);
        if (messageFixup.exists()) {
            this.rebaseState.createFile(MESSAGE_FIXUP, content);
        }
        return this.squashIntoPrevious(!messageFixup.exists(), nextStep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetSoftToParent() throws IOException, GitAPIException, CheckoutConflictException {
        Ref ref = this.repo.exactRef("ORIG_HEAD");
        ObjectId orig_head = ref == null ? null : ref.getObjectId();
        try (Git git = Git.wrap(this.repo);){
            git.reset().setMode(ResetCommand.ResetType.SOFT).setRef("HEAD~1").call();
        }
        finally {
            this.repo.writeOrigHead(orig_head);
        }
    }

    private RevCommit squashIntoPrevious(boolean sequenceContainsSquash, RebaseTodoLine nextStep) throws IOException, GitAPIException {
        RevCommit retNewHead;
        String commitMessage = this.rebaseState.readFile(MESSAGE_SQUASH);
        try (Git git = new Git(this.repo);){
            if (nextStep == null || nextStep.getAction() != RebaseTodoLine.Action.FIXUP && nextStep.getAction() != RebaseTodoLine.Action.SQUASH) {
                if (sequenceContainsSquash) {
                    commitMessage = this.interactiveHandler.modifyCommitMessage(commitMessage);
                }
                retNewHead = git.commit().setMessage(RebaseCommand.stripCommentLines(commitMessage)).setAmend(true).setNoVerify(true).call();
                this.rebaseState.getFile(MESSAGE_SQUASH).delete();
                this.rebaseState.getFile(MESSAGE_FIXUP).delete();
            } else {
                retNewHead = git.commit().setMessage(commitMessage).setAmend(true).setNoVerify(true).call();
            }
        }
        return retNewHead;
    }

    private static String stripCommentLines(String commitMessage) {
        int bufferSize;
        StringBuilder result = new StringBuilder();
        for (String line : commitMessage.split("\n")) {
            if (line.trim().startsWith("#")) continue;
            result.append(line).append("\n");
        }
        if (!commitMessage.endsWith("\n") && (bufferSize = result.length()) > 0 && result.charAt(bufferSize - 1) == '\n') {
            result.deleteCharAt(bufferSize - 1);
        }
        return result.toString();
    }

    private static String composeSquashMessage(boolean isSquash, RevCommit commitToPick, String currSquashMessage, int count) {
        StringBuilder sb = new StringBuilder();
        String ordinal = RebaseCommand.getOrdinal(count);
        sb.setLength(0);
        sb.append("# This is a combination of ").append(count).append(" commits.\n");
        sb.append(currSquashMessage.substring(currSquashMessage.indexOf("\n") + 1));
        sb.append("\n");
        if (isSquash) {
            sb.append("# This is the ").append(count).append(ordinal).append(" commit message:\n");
            sb.append(commitToPick.getFullMessage());
        } else {
            sb.append("# The ").append(count).append(ordinal).append(" commit message will be skipped:\n# ");
            sb.append(commitToPick.getFullMessage().replaceAll("([\n\r])", "$1# "));
        }
        return sb.toString();
    }

    private static String getOrdinal(int count) {
        switch (count % 10) {
            case 1: {
                return "st";
            }
            case 2: {
                return "nd";
            }
            case 3: {
                return "rd";
            }
        }
        return "th";
    }

    static int parseSquashFixupSequenceCount(String currSquashMessage) {
        String regex = "This is a combination of (.*) commits";
        String firstLine = currSquashMessage.substring(0, currSquashMessage.indexOf("\n"));
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(firstLine);
        if (!matcher.find()) {
            throw new IllegalArgumentException();
        }
        return Integer.parseInt(matcher.group(1));
    }

    private void initializeSquashFixupFile(String messageFile, String fullMessage) throws IOException {
        this.rebaseState.createFile(messageFile, "# This is a combination of 1 commits.\n# The first commit's message is:\n" + fullMessage);
    }

    private String getOurCommitName() {
        String ourCommitName = "Upstream, based on " + Repository.shortenRefName(this.upstreamCommitName);
        return ourCommitName;
    }

    private void updateHead(String headName, RevCommit aNewHead, RevCommit onto) throws IOException {
        if (headName.startsWith("refs/")) {
            RefUpdate rup = this.repo.updateRef(headName);
            rup.setNewObjectId(aNewHead);
            rup.setRefLogMessage("rebase finished: " + headName + " onto " + onto.getName(), false);
            RefUpdate.Result res = rup.forceUpdate();
            switch (res) {
                case FAST_FORWARD: 
                case FORCED: 
                case NO_CHANGE: {
                    break;
                }
                default: {
                    throw new JGitInternalException(JGitText.get().updatingHeadFailed);
                }
            }
            rup = this.repo.updateRef("HEAD");
            rup.setRefLogMessage("rebase finished: returning to " + headName, false);
            res = rup.link(headName);
            switch (res) {
                case FAST_FORWARD: 
                case FORCED: 
                case NO_CHANGE: {
                    break;
                }
                default: {
                    throw new JGitInternalException(JGitText.get().updatingHeadFailed);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RevCommit checkoutCurrentHead() throws IOException, NoHeadException {
        ObjectId headTree = this.repo.resolve("HEAD^{tree}");
        if (headTree == null) {
            throw new NoHeadException(JGitText.get().cannotRebaseWithoutCurrentHead);
        }
        DirCache dc = this.repo.lockDirCache();
        try {
            DirCacheCheckout dco = new DirCacheCheckout(this.repo, dc, headTree);
            dco.setFailOnConflict(false);
            boolean needsDeleteFiles = dco.checkout();
            if (needsDeleteFiles) {
                List<String> fileList = dco.getToBeDeleted();
                for (String filePath : fileList) {
                    File fileToDelete = new File(this.repo.getWorkTree(), filePath);
                    if (!this.repo.getFS().exists(fileToDelete)) continue;
                    FileUtils.delete(fileToDelete, 3);
                }
            }
        }
        finally {
            dc.unlock();
        }
        try (RevWalk rw = new RevWalk(this.repo);){
            RevCommit commit = rw.parseCommit(this.repo.resolve("HEAD"));
            RevCommit revCommit = commit;
            return revCommit;
        }
    }

    private RevCommit continueRebase() throws GitAPIException, IOException {
        boolean needsCommit;
        DirCache dc = this.repo.readDirCache();
        boolean hasUnmergedPaths = dc.hasUnmergedPaths();
        if (hasUnmergedPaths) {
            throw new UnmergedPathsException();
        }
        try (TreeWalk treeWalk = new TreeWalk(this.repo);){
            treeWalk.reset();
            treeWalk.setRecursive(true);
            treeWalk.addTree(new DirCacheIterator(dc));
            ObjectId id = this.repo.resolve("HEAD^{tree}");
            if (id == null) {
                throw new NoHeadException(JGitText.get().cannotRebaseWithoutCurrentHead);
            }
            treeWalk.addTree(id);
            treeWalk.setFilter(TreeFilter.ANY_DIFF);
            needsCommit = treeWalk.next();
        }
        if (needsCommit) {
            var5_4 = null;
            try (Git git = new Git(this.repo);){
                CommitCommand commit = git.commit();
                commit.setMessage(this.rebaseState.readFile(MESSAGE));
                commit.setAuthor(this.parseAuthor());
                RevCommit revCommit = commit.call();
                return revCommit;
            }
            catch (Throwable throwable) {
                var5_4 = throwable;
                throw throwable;
            }
        }
        return null;
    }

    private PersonIdent parseAuthor() throws IOException {
        byte[] raw;
        File authorScriptFile = this.rebaseState.getFile(AUTHOR_SCRIPT);
        try {
            raw = IO.readFully(authorScriptFile);
        }
        catch (FileNotFoundException notFound) {
            if (authorScriptFile.exists()) {
                throw notFound;
            }
            return null;
        }
        return this.parseAuthor(raw);
    }

    private RebaseResult stop(RevCommit commitToPick, RebaseResult.Status status) throws IOException {
        PersonIdent author = commitToPick.getAuthorIdent();
        String authorScript = this.toAuthorScript(author);
        this.rebaseState.createFile(AUTHOR_SCRIPT, authorScript);
        this.rebaseState.createFile(MESSAGE, commitToPick.getFullMessage());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (DiffFormatter df = new DiffFormatter(bos);){
            df.setRepository(this.repo);
            df.format(commitToPick.getParent(0), commitToPick);
        }
        this.rebaseState.createFile(PATCH, new String(bos.toByteArray(), "UTF-8"));
        this.rebaseState.createFile(STOPPED_SHA, this.repo.newObjectReader().abbreviate(commitToPick).name());
        this.repo.writeCherryPickHead(null);
        return RebaseResult.result(status, commitToPick);
    }

    String toAuthorScript(PersonIdent author) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(GIT_AUTHOR_NAME);
        sb.append("='");
        sb.append(author.getName());
        sb.append("'\n");
        sb.append(GIT_AUTHOR_EMAIL);
        sb.append("='");
        sb.append(author.getEmailAddress());
        sb.append("'\n");
        sb.append(GIT_AUTHOR_DATE);
        sb.append("='");
        sb.append("@");
        String externalString = author.toExternalString();
        sb.append(externalString.substring(externalString.lastIndexOf(62) + 2));
        sb.append("'\n");
        return sb.toString();
    }

    private void popSteps(int numSteps) throws IOException {
        if (numSteps == 0) {
            return;
        }
        LinkedList<RebaseTodoLine> todoLines = new LinkedList<RebaseTodoLine>();
        LinkedList<RebaseTodoLine> poppedLines = new LinkedList<RebaseTodoLine>();
        for (RebaseTodoLine line : this.repo.readRebaseTodo(this.rebaseState.getPath(GIT_REBASE_TODO), true)) {
            if (poppedLines.size() >= numSteps || RebaseTodoLine.Action.COMMENT.equals((Object)line.getAction())) {
                todoLines.add(line);
                continue;
            }
            poppedLines.add(line);
        }
        this.repo.writeRebaseTodoFile(this.rebaseState.getPath(GIT_REBASE_TODO), todoLines, false);
        if (poppedLines.size() > 0) {
            this.repo.writeRebaseTodoFile(this.rebaseState.getPath(DONE), poppedLines, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RebaseResult initFilesAndRewind() throws IOException, GitAPIException {
        Ref head = this.getHead();
        ObjectId headId = head.getObjectId();
        if (headId == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, "HEAD"));
        }
        String headName = RebaseCommand.getHeadName(head);
        RevCommit headCommit = this.walk.lookupCommit(headId);
        RevCommit upstream = this.walk.lookupCommit(this.upstreamCommit.getId());
        if (!this.isInteractive() && this.walk.isMergedInto(upstream, headCommit)) {
            return RebaseResult.UP_TO_DATE_RESULT;
        }
        if (!this.isInteractive() && this.walk.isMergedInto(headCommit, upstream)) {
            this.monitor.beginTask(MessageFormat.format(JGitText.get().resettingHead, this.upstreamCommit.getShortMessage()), 0);
            this.checkoutCommit(headName, this.upstreamCommit);
            this.monitor.endTask();
            this.updateHead(headName, this.upstreamCommit, upstream);
            return RebaseResult.FAST_FORWARD_RESULT;
        }
        this.monitor.beginTask(JGitText.get().obtainingCommitsForCherryPick, 0);
        FileUtils.mkdir(this.rebaseState.getDir(), true);
        this.repo.writeOrigHead(headId);
        this.rebaseState.createFile(REBASE_HEAD, headId.name());
        this.rebaseState.createFile(HEAD_NAME, headName);
        this.rebaseState.createFile(ONTO, this.upstreamCommit.name());
        this.rebaseState.createFile(ONTO_NAME, this.upstreamCommitName);
        if (this.isInteractive()) {
            this.rebaseState.createFile(INTERACTIVE, "");
        }
        this.rebaseState.createFile(QUIET, "");
        ArrayList<RebaseTodoLine> toDoSteps = new ArrayList<RebaseTodoLine>();
        toDoSteps.add(new RebaseTodoLine("# Created by EGit: rebasing " + headId.name() + " onto " + this.upstreamCommit.name()));
        List<RevCommit> cherryPickList = this.calculatePickList(headCommit);
        ObjectReader reader = this.walk.getObjectReader();
        for (RevCommit commit : cherryPickList) {
            toDoSteps.add(new RebaseTodoLine(RebaseTodoLine.Action.PICK, reader.abbreviate(commit), commit.getShortMessage()));
        }
        this.repo.writeRebaseTodoFile(this.rebaseState.getPath(GIT_REBASE_TODO), toDoSteps, false);
        this.monitor.endTask();
        this.monitor.beginTask(MessageFormat.format(JGitText.get().rewinding, this.upstreamCommit.getShortMessage()), 0);
        boolean checkoutOk = false;
        try {
            checkoutOk = this.checkoutCommit(headName, this.upstreamCommit);
        }
        finally {
            if (!checkoutOk) {
                FileUtils.delete(this.rebaseState.getDir(), 1);
            }
        }
        this.monitor.endTask();
        return null;
    }

    private List<RevCommit> calculatePickList(RevCommit headCommit) throws GitAPIException, NoHeadException, IOException {
        Object commitsToUse;
        Git git = new Git(this.repo);
        Object object = null;
        try {
            LogCommand cmd = git.log().addRange(this.upstreamCommit, headCommit);
            commitsToUse = cmd.call();
        }
        catch (Throwable cmd) {
            object = cmd;
            throw cmd;
        }
        finally {
            RebaseCommand.$closeResource((Throwable)object, git);
        }
        ArrayList<RevCommit> cherryPickList = new ArrayList<RevCommit>();
        object = commitsToUse.iterator();
        while (object.hasNext()) {
            RevCommit commit = (RevCommit)object.next();
            if (!this.preserveMerges && commit.getParentCount() != 1) continue;
            cherryPickList.add(commit);
        }
        Collections.reverse(cherryPickList);
        if (this.preserveMerges) {
            RevCommit base;
            File rewrittenDir = this.rebaseState.getRewrittenDir();
            FileUtils.mkdir(rewrittenDir, false);
            this.walk.reset();
            this.walk.setRevFilter(RevFilter.MERGE_BASE);
            this.walk.markStart(this.upstreamCommit);
            this.walk.markStart(headCommit);
            while ((base = this.walk.next()) != null) {
                RebaseState.createFile(rewrittenDir, base.getName(), this.upstreamCommit.getName());
            }
            Iterator iterator = cherryPickList.iterator();
            block7: while (iterator.hasNext()) {
                RevCommit commit = (RevCommit)iterator.next();
                for (int i = 0; i < commit.getParentCount(); ++i) {
                    boolean parentRewritten = new File(rewrittenDir, commit.getParent(i).getName()).exists();
                    if (!parentRewritten) continue;
                    new File(rewrittenDir, commit.getName()).createNewFile();
                    continue block7;
                }
                iterator.remove();
            }
        }
        return cherryPickList;
    }

    private static String getHeadName(Ref head) {
        String headName;
        if (head.isSymbolic()) {
            headName = head.getTarget().getName();
        } else {
            ObjectId headId = head.getObjectId();
            assert (headId != null);
            headName = headId.getName();
        }
        return headName;
    }

    private Ref getHead() throws IOException, RefNotFoundException {
        Ref head = this.repo.exactRef("HEAD");
        if (head == null || head.getObjectId() == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, "HEAD"));
        }
        return head;
    }

    private boolean isInteractive() {
        return this.interactiveHandler != null;
    }

    public RevCommit tryFastForward(RevCommit newCommit) throws IOException, GitAPIException {
        Ref head = this.getHead();
        ObjectId headId = head.getObjectId();
        if (headId == null) {
            throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, "HEAD"));
        }
        RevCommit headCommit = this.walk.lookupCommit(headId);
        if (this.walk.isMergedInto(newCommit, headCommit)) {
            return newCommit;
        }
        String headName = RebaseCommand.getHeadName(head);
        return this.tryFastForward(headName, headCommit, newCommit);
    }

    private RevCommit tryFastForward(String headName, RevCommit oldCommit, RevCommit newCommit) throws IOException, GitAPIException {
        boolean tryRebase = false;
        for (RevCommit parentCommit : newCommit.getParents()) {
            if (!parentCommit.equals(oldCommit)) continue;
            tryRebase = true;
        }
        if (!tryRebase) {
            return null;
        }
        CheckoutCommand co = new CheckoutCommand(this.repo);
        try {
            co.setName(newCommit.name()).call();
            if (headName.startsWith("refs/heads/")) {
                RefUpdate rup = this.repo.updateRef(headName);
                rup.setExpectedOldObjectId(oldCommit);
                rup.setNewObjectId(newCommit);
                rup.setRefLogMessage("Fast-forward from " + oldCommit.name() + " to " + newCommit.name(), false);
                RefUpdate.Result res = rup.update(this.walk);
                switch (res) {
                    case FAST_FORWARD: 
                    case FORCED: 
                    case NO_CHANGE: {
                        break;
                    }
                    default: {
                        throw new IOException("Could not fast-forward");
                    }
                }
            }
            return newCommit;
        }
        catch (RefAlreadyExistsException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (RefNotFoundException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (InvalidRefNameException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        catch (CheckoutConflictException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
    }

    private void checkParameters() throws WrongRepositoryStateException {
        block9: {
            block8: {
                if (this.operation == Operation.PROCESS_STEPS && this.rebaseState.getFile(DONE).exists()) {
                    throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().wrongRepositoryState, this.repo.getRepositoryState().name()));
                }
                if (this.operation == Operation.BEGIN) break block8;
                switch (this.repo.getRepositoryState()) {
                    case REBASING_INTERACTIVE: 
                    case REBASING: 
                    case REBASING_REBASING: 
                    case REBASING_MERGE: {
                        break block9;
                    }
                    default: {
                        throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().wrongRepositoryState, this.repo.getRepositoryState().name()));
                    }
                }
            }
            switch (this.repo.getRepositoryState()) {
                case SAFE: {
                    if (this.upstreamCommit == null) {
                        throw new JGitInternalException(MessageFormat.format(JGitText.get().missingRequiredParameter, "upstream"));
                    }
                    return;
                }
            }
            throw new WrongRepositoryStateException(MessageFormat.format(JGitText.get().wrongRepositoryState, this.repo.getRepositoryState().name()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RebaseResult abort(RebaseResult result) throws IOException, GitAPIException {
        try {
            DirCacheCheckout dco;
            ObjectId origHead = this.repo.readOrigHead();
            String commitId = origHead != null ? origHead.name() : null;
            this.monitor.beginTask(MessageFormat.format(JGitText.get().abortingRebase, commitId), 0);
            if (commitId == null) {
                throw new JGitInternalException(JGitText.get().abortingRebaseFailedNoOrigHead);
            }
            ObjectId id = this.repo.resolve(commitId);
            RevCommit commit = this.walk.parseCommit(id);
            if (result.getStatus().equals((Object)RebaseResult.Status.FAILED)) {
                RevCommit head = this.walk.parseCommit(this.repo.resolve("HEAD"));
                dco = new DirCacheCheckout(this.repo, head.getTree(), this.repo.lockDirCache(), commit.getTree());
            } else {
                dco = new DirCacheCheckout(this.repo, this.repo.lockDirCache(), commit.getTree());
            }
            dco.setFailOnConflict(false);
            dco.checkout();
            this.walk.close();
        }
        finally {
            this.monitor.endTask();
        }
        try {
            RebaseResult rebaseResult;
            String headName = this.rebaseState.readFile(HEAD_NAME);
            this.monitor.beginTask(MessageFormat.format(JGitText.get().resettingHead, headName), 0);
            RefUpdate.Result res = null;
            RefUpdate refUpdate = this.repo.updateRef("HEAD", false);
            refUpdate.setRefLogMessage("rebase: aborting", false);
            if (headName.startsWith("refs/")) {
                res = refUpdate.link(headName);
            } else {
                refUpdate.setNewObjectId(this.repo.readOrigHead());
                res = refUpdate.forceUpdate();
            }
            switch (res) {
                case FAST_FORWARD: 
                case FORCED: 
                case NO_CHANGE: {
                    break;
                }
                default: {
                    throw new JGitInternalException(JGitText.get().abortingRebaseFailed);
                }
            }
            boolean stashConflicts = this.autoStashApply();
            FileUtils.delete(this.rebaseState.getDir(), 1);
            this.repo.writeCherryPickHead(null);
            this.repo.writeMergeHeads(null);
            if (stashConflicts) {
                rebaseResult = RebaseResult.STASH_APPLY_CONFLICTS_RESULT;
                return rebaseResult;
            }
            rebaseResult = result;
            return rebaseResult;
        }
        finally {
            this.monitor.endTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkoutCommit(String headName, RevCommit commit) throws IOException, CheckoutConflictException {
        try {
            RevCommit head = this.walk.parseCommit(this.repo.resolve("HEAD"));
            DirCacheCheckout dco = new DirCacheCheckout(this.repo, head.getTree(), this.repo.lockDirCache(), commit.getTree());
            dco.setFailOnConflict(true);
            try {
                dco.checkout();
            }
            catch (io.cucumber.pro.shaded.org.eclipse.jgit.errors.CheckoutConflictException cce) {
                throw new CheckoutConflictException(dco.getConflicts(), cce);
            }
            RefUpdate refUpdate = this.repo.updateRef("HEAD", true);
            refUpdate.setExpectedOldObjectId(head);
            refUpdate.setNewObjectId(commit);
            refUpdate.setRefLogMessage("checkout: moving from " + Repository.shortenRefName(headName) + " to " + commit.getName(), false);
            RefUpdate.Result res = refUpdate.forceUpdate();
            switch (res) {
                case FAST_FORWARD: 
                case FORCED: 
                case NO_CHANGE: {
                    return true;
                }
                default: {
                    throw new IOException(JGitText.get().couldNotRewindToUpstreamCommit);
                }
            }
        }
        finally {
            this.walk.close();
            this.monitor.endTask();
        }
    }

    public RebaseCommand setUpstream(RevCommit upstream) {
        this.upstreamCommit = upstream;
        this.upstreamCommitName = upstream.name();
        return this;
    }

    public RebaseCommand setUpstream(AnyObjectId upstream) {
        try {
            this.upstreamCommit = this.walk.parseCommit(upstream);
            this.upstreamCommitName = upstream.name();
        }
        catch (IOException e) {
            throw new JGitInternalException(MessageFormat.format(JGitText.get().couldNotReadObjectWhileParsingCommit, upstream.name()), e);
        }
        return this;
    }

    public RebaseCommand setUpstream(String upstream) throws RefNotFoundException {
        try {
            ObjectId upstreamId = this.repo.resolve(upstream);
            if (upstreamId == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, upstream));
            }
            this.upstreamCommit = this.walk.parseCommit(this.repo.resolve(upstream));
            this.upstreamCommitName = upstream;
            return this;
        }
        catch (IOException ioe) {
            throw new JGitInternalException(ioe.getMessage(), ioe);
        }
    }

    public RebaseCommand setUpstreamName(String upstreamName) {
        if (this.upstreamCommit == null) {
            throw new IllegalStateException("setUpstreamName must be called after setUpstream.");
        }
        this.upstreamCommitName = upstreamName;
        return this;
    }

    public RebaseCommand setOperation(Operation operation) {
        this.operation = operation;
        return this;
    }

    public RebaseCommand setProgressMonitor(ProgressMonitor monitor) {
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        this.monitor = monitor;
        return this;
    }

    public RebaseCommand runInteractively(InteractiveHandler handler) {
        return this.runInteractively(handler, false);
    }

    public RebaseCommand runInteractively(InteractiveHandler handler, boolean stopAfterRebaseInteractiveInitialization) {
        this.stopAfterInitialization = stopAfterRebaseInteractiveInitialization;
        this.interactiveHandler = handler;
        return this;
    }

    public RebaseCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public RebaseCommand setPreserveMerges(boolean preserve) {
        this.preserveMerges = preserve;
        return this;
    }

    PersonIdent parseAuthor(byte[] raw) {
        int equalsIndex;
        int end;
        if (raw.length == 0) {
            return null;
        }
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        int p = 0;
        while (p < raw.length && (end = RawParseUtils.nextLF(raw, p)) != p && (equalsIndex = RawParseUtils.next(raw, p, '=')) != end) {
            String key = RawParseUtils.decode(raw, p, equalsIndex - 1);
            String value = RawParseUtils.decode(raw, equalsIndex + 1, end - 2);
            p = end;
            keyValueMap.put(key, value);
        }
        String name = (String)keyValueMap.get(GIT_AUTHOR_NAME);
        String email = (String)keyValueMap.get(GIT_AUTHOR_EMAIL);
        String time = (String)keyValueMap.get(GIT_AUTHOR_DATE);
        int timeStart = 0;
        timeStart = time.startsWith("@") ? 1 : 0;
        long when = Long.parseLong(time.substring(timeStart, time.indexOf(32))) * 1000L;
        String tzOffsetString = time.substring(time.indexOf(32) + 1);
        int multiplier = -1;
        if (tzOffsetString.charAt(0) == '+') {
            multiplier = 1;
        }
        int hours = Integer.parseInt(tzOffsetString.substring(1, 3));
        int minutes = Integer.parseInt(tzOffsetString.substring(3, 5));
        int tz = (hours * 60 + minutes) * multiplier;
        if (name != null && email != null) {
            return new PersonIdent(name, email, when, tz);
        }
        return null;
    }

    public static interface InteractiveHandler {
        public void prepareSteps(List<RebaseTodoLine> var1);

        public String modifyCommitMessage(String var1);
    }

    public static enum Operation {
        BEGIN,
        CONTINUE,
        SKIP,
        ABORT,
        PROCESS_STEPS;

    }

    private static class RebaseState {
        private final File repoDirectory;
        private File dir;

        public RebaseState(File repoDirectory) {
            this.repoDirectory = repoDirectory;
        }

        public File getDir() {
            if (this.dir == null) {
                File rebaseMerge;
                File rebaseApply = new File(this.repoDirectory, RebaseCommand.REBASE_APPLY);
                this.dir = rebaseApply.exists() ? rebaseApply : (rebaseMerge = new File(this.repoDirectory, RebaseCommand.REBASE_MERGE));
            }
            return this.dir;
        }

        public File getRewrittenDir() {
            return new File(this.getDir(), RebaseCommand.REWRITTEN);
        }

        public String readFile(String name) throws IOException {
            return RebaseState.readFile(this.getDir(), name);
        }

        public void createFile(String name, String content) throws IOException {
            RebaseState.createFile(this.getDir(), name, content);
        }

        public File getFile(String name) {
            return new File(this.getDir(), name);
        }

        public String getPath(String name) {
            return this.getDir().getName() + "/" + name;
        }

        private static String readFile(File directory, String fileName) throws IOException {
            byte[] content = IO.readFully(new File(directory, fileName));
            int end = RawParseUtils.prevLF(content, content.length);
            return RawParseUtils.decode(content, 0, end + 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void createFile(File parentDir, String name, String content) throws IOException {
            File file = new File(parentDir, name);
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(content.getBytes("UTF-8"));
                fos.write(10);
            }
        }

        private static void appendToFile(File file, String content) throws IOException {
            try (FileOutputStream fos = new FileOutputStream(file, true);){
                fos.write(content.getBytes("UTF-8"));
                fos.write(10);
            }
        }
    }
}

