/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.api;

import io.cucumber.pro.shaded.org.eclipse.jgit.api.GitCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.GitAPIException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.JGitInternalException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.RefNotFoundException;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.JGitText;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectId;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Ref;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevCommit;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevWalk;
import io.cucumber.pro.shaded.org.eclipse.jgit.revwalk.RevWalkUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ListBranchCommand
extends GitCommand<List<Ref>> {
    private ListMode listMode;
    private String containsCommitish;

    protected ListBranchCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<Ref> call() throws GitAPIException {
        ArrayList<Ref> resultRefs;
        this.checkCallable();
        try {
            ArrayList<Ref> refs = new ArrayList<Ref>();
            Ref head = this.repo.exactRef("HEAD");
            if (head != null && head.getLeaf().getName().equals("HEAD")) {
                refs.add(head);
            }
            if (this.listMode == null) {
                refs.addAll(this.getRefs("refs/heads/"));
            } else if (this.listMode == ListMode.REMOTE) {
                refs.addAll(this.getRefs("refs/remotes/"));
            } else {
                refs.addAll(this.getRefs("refs/heads/"));
                refs.addAll(this.getRefs("refs/remotes/"));
            }
            resultRefs = new ArrayList<Ref>(this.filterRefs(refs));
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        Collections.sort(resultRefs, new Comparator<Ref>(){

            @Override
            public int compare(Ref o1, Ref o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.setCallable(false);
        return resultRefs;
    }

    private Collection<Ref> filterRefs(Collection<Ref> refs) throws RefNotFoundException, IOException {
        if (this.containsCommitish == null) {
            return refs;
        }
        try (RevWalk walk = new RevWalk(this.repo);){
            ObjectId resolved = this.repo.resolve(this.containsCommitish);
            if (resolved == null) {
                throw new RefNotFoundException(MessageFormat.format(JGitText.get().refNotResolved, this.containsCommitish));
            }
            RevCommit containsCommit = walk.parseCommit(resolved);
            List<Ref> list = RevWalkUtils.findBranchesReachableFrom(containsCommit, walk, refs);
            return list;
        }
    }

    public ListBranchCommand setListMode(ListMode listMode) {
        this.checkCallable();
        this.listMode = listMode;
        return this;
    }

    public ListBranchCommand setContains(String containsCommitish) {
        this.checkCallable();
        this.containsCommitish = containsCommitish;
        return this;
    }

    private Collection<Ref> getRefs(String prefix) throws IOException {
        return this.repo.getRefDatabase().getRefs(prefix).values();
    }

    public static enum ListMode {
        ALL,
        REMOTE;

    }
}

