/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro;

import cucumber.runtime.CucumberException;
import gherkin.formatter.JSONFormatter;
import io.cucumber.pro.Env;
import io.cucumber.pro.EnvFactory;
import io.cucumber.pro.FilteredEnv;
import io.cucumber.pro.Logger;
import io.cucumber.pro.documentation.DocumentationPublisher;
import io.cucumber.pro.documentation.DocumentationPublisherFactory;
import io.cucumber.pro.results.ResultsPublisher;
import io.cucumber.pro.results.ResultsPublisherFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class JsonReporter12
extends JSONFormatter {
    private static final Env ENV = EnvFactory.create(System.getenv());
    private static final Logger LOGGER = new Logger.SystemLogger(ENV);
    private static final File jsonFile;
    private final FilteredEnv filteredEnv;
    private final ResultsPublisher resultsPublisher;
    private final String profileName;
    private final DocumentationPublisher documentationPublisher;

    JsonReporter12(DocumentationPublisher documentationPublisher, ResultsPublisher resultsPublisher, Env env, String profileName) throws IOException {
        super((Appendable)new FileWriter(jsonFile));
        this.documentationPublisher = documentationPublisher;
        this.resultsPublisher = resultsPublisher;
        this.profileName = profileName;
        this.filteredEnv = new FilteredEnv(env);
    }

    JsonReporter12(String profileName) throws IOException {
        this(DocumentationPublisherFactory.create(ENV, LOGGER), ResultsPublisherFactory.create(ENV, LOGGER), ENV, profileName);
    }

    public JsonReporter12(File fileUsedToGetProfileName) throws IOException {
        this(fileUsedToGetProfileName.getName());
        fileUsedToGetProfileName.delete();
    }

    public void close() {
        super.close();
        this.documentationPublisher.publish();
        this.resultsPublisher.publish(jsonFile, this.filteredEnv.toString(), this.profileName);
    }

    static {
        try {
            jsonFile = File.createTempFile("cucumber-json", ".json");
            jsonFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
    }
}

