/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro;

import io.cucumber.pro.Env;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

class FilteredEnv {
    private static final String DEFAULT_ENV_MASK = "SECRET|KEY|TOKEN|PASSWORD";
    private final Pattern maskPattern;
    private final Env env;

    FilteredEnv(Env env) {
        String mask = env.get("CUCUMBER_PRO_ENV_MASK", DEFAULT_ENV_MASK);
        this.maskPattern = Pattern.compile(String.format(".*(%s).*", mask), 2);
        this.env = env;
    }

    private Map<String, String> clean() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.env.all().entrySet()) {
            if (this.maskPattern.matcher(entry.getKey()).matches()) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public String toString() {
        StringBuilder envb = new StringBuilder();
        Map<String, String> clean = this.clean();
        ArrayList<String> sortedKeys = new ArrayList<String>(clean.keySet());
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            envb.append(key).append("=").append(clean.get(key)).append("\n");
        }
        return envb.toString();
    }
}

