/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.dfs;

import io.cucumber.pro.shaded.org.eclipse.jgit.errors.LargeObjectException;
import io.cucumber.pro.shaded.org.eclipse.jgit.errors.MissingObjectException;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.dfs.DfsReader;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.storage.dfs.PackInputStream;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectLoader;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.ObjectStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;

final class LargePackedWholeObject
extends ObjectLoader {
    private final int type;
    private final long size;
    private final long objectOffset;
    private final int headerLength;
    private final DfsPackFile pack;
    private final DfsObjDatabase db;

    LargePackedWholeObject(int type, long size, long objectOffset, int headerLength, DfsPackFile pack, DfsObjDatabase db) {
        this.type = type;
        this.size = size;
        this.objectOffset = objectOffset;
        this.headerLength = headerLength;
        this.pack = pack;
        this.db = db;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public boolean isLarge() {
        return true;
    }

    @Override
    public byte[] getCachedBytes() throws LargeObjectException {
        throw new LargeObjectException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectStream openStream() throws MissingObjectException, IOException {
        InputStream in;
        try (DfsReader ctx = this.db.newReader();){
            in = new PackInputStream(this.pack, this.objectOffset + (long)this.headerLength, ctx);
        }
        int bufsz = 8192;
        in = new BufferedInputStream(new InflaterInputStream(in, ctx.inflater(), bufsz), bufsz);
        return new ObjectStream.Filter(this.type, this.size, in);
    }
}

