/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.internal.ketch;

import io.cucumber.pro.shaded.org.eclipse.jgit.annotations.Nullable;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.ketch.KetchLeader;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.ketch.KetchReplica;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.ketch.LocalReplica;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.ketch.RemoteGitReplica;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.ketch.ReplicaConfig;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Config;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.PersonIdent;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.StoredConfig;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.RemoteConfig;
import io.cucumber.pro.shaded.org.eclipse.jgit.transport.URIish;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.time.MonotonicClock;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.time.MonotonicSystemClock;
import io.cucumber.pro.shaded.org.eclipse.jgit.util.time.ProposedTimestamp;
import io.cucumber.pro.shaded.org.slf4j.Logger;
import io.cucumber.pro.shaded.org.slf4j.LoggerFactory;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class KetchSystem {
    private static final Random RNG = new Random();
    private final ScheduledExecutorService executor;
    private final MonotonicClock clock;
    private final String txnNamespace;
    private final String txnAccepted;
    private final String txnCommitted;
    private final String txnStage;

    public static ScheduledExecutorService defaultExecutor() {
        return DefaultExecutorHolder.I;
    }

    public KetchSystem() {
        this(KetchSystem.defaultExecutor(), new MonotonicSystemClock(), "refs/txn/");
    }

    public KetchSystem(ScheduledExecutorService executor, MonotonicClock clock, String txnNamespace) {
        this.executor = executor;
        this.clock = clock;
        this.txnNamespace = txnNamespace;
        this.txnAccepted = txnNamespace + "accepted";
        this.txnCommitted = txnNamespace + "committed";
        this.txnStage = txnNamespace + "stage/";
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public MonotonicClock getClock() {
        return this.clock;
    }

    public Duration getMaxWaitForMonotonicClock() {
        return Duration.ofSeconds(5L);
    }

    public boolean requireMonotonicLeaderElections() {
        return false;
    }

    public String getTxnNamespace() {
        return this.txnNamespace;
    }

    public String getTxnAccepted() {
        return this.txnAccepted;
    }

    public String getTxnCommitted() {
        return this.txnCommitted;
    }

    public String getTxnStage() {
        return this.txnStage;
    }

    public PersonIdent newCommitter(ProposedTimestamp time) {
        String name = "ketch";
        String email = "ketch@system";
        return new PersonIdent(name, email, time);
    }

    @Nullable
    public String newLeaderTag() {
        int n = RNG.nextInt(0x1000000);
        return String.format("%06x", n);
    }

    public KetchLeader createLeader(final Repository repo) throws URISyntaxException {
        KetchLeader leader = new KetchLeader(this){

            @Override
            protected Repository openRepository() {
                repo.incrementOpen();
                return repo;
            }
        };
        leader.setReplicas(this.createReplicas(leader, repo));
        return leader;
    }

    protected List<KetchReplica> createReplicas(KetchLeader leader, Repository repo) throws URISyntaxException {
        ArrayList<KetchReplica> replicas = new ArrayList<KetchReplica>();
        StoredConfig cfg = repo.getConfig();
        String localName = KetchSystem.getLocalName(cfg);
        for (String name : cfg.getSubsections("remote")) {
            if (!KetchSystem.hasParticipation(cfg, name)) continue;
            ReplicaConfig kc = ReplicaConfig.newFromConfig(cfg, name);
            if (name.equals(localName)) {
                replicas.add(new LocalReplica(leader, name, kc));
                continue;
            }
            RemoteConfig rc = new RemoteConfig(cfg, name);
            List<URIish> uris = rc.getPushURIs();
            if (uris.isEmpty()) {
                uris = rc.getURIs();
            }
            for (URIish uri : uris) {
                String n = uris.size() == 1 ? name : uri.getHost();
                replicas.add(new RemoteGitReplica(leader, n, uri, kc, rc));
            }
        }
        return replicas;
    }

    private static boolean hasParticipation(Config cfg, String name) {
        return cfg.getString("remote", name, "ketch-type") != null;
    }

    private static String getLocalName(Config cfg) {
        return cfg.getString("ketch", null, "name");
    }

    static long delay(long last, long min, long max) {
        long r = Math.max(0L, last * 3L - min);
        if (r > 0L) {
            int c = (int)Math.min(r + 1L, Integer.MAX_VALUE);
            r = RNG.nextInt(c);
        }
        return Math.max(Math.min(min + r, max), min);
    }

    static class DefaultExecutorHolder {
        private static final Logger log = LoggerFactory.getLogger(KetchSystem.class);
        static final ScheduledExecutorService I = DefaultExecutorHolder.create();

        private static ScheduledExecutorService create() {
            int cores = Runtime.getRuntime().availableProcessors();
            int threads = Math.max(5, cores);
            log.info("Using {} threads", (Object)threads);
            return Executors.newScheduledThreadPool(threads, new ThreadFactory(){
                private final AtomicInteger threadCnt = new AtomicInteger();

                @Override
                public Thread newThread(Runnable r) {
                    int id = this.threadCnt.incrementAndGet();
                    Thread thr = new Thread(r);
                    thr.setName("KetchExecutor-" + id);
                    return thr;
                }
            });
        }

        private DefaultExecutorHolder() {
        }
    }
}

