/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.blame;

class Region {
    Region next;
    int resultStart;
    int sourceStart;
    int length;

    Region(int rs, int ss, int len) {
        this.resultStart = rs;
        this.sourceStart = ss;
        this.length = len;
    }

    Region copy(int newSource) {
        return new Region(this.resultStart, newSource, this.length);
    }

    Region splitFirst(int newSource, int newLen) {
        return new Region(this.resultStart, newSource, newLen);
    }

    void slideAndShrink(int d) {
        this.resultStart += d;
        this.sourceStart += d;
        this.length -= d;
    }

    Region deepCopy() {
        Region head;
        Region tail = head = new Region(this.resultStart, this.sourceStart, this.length);
        Region n = this.next;
        while (n != null) {
            Region q;
            tail.next = q = new Region(n.resultStart, n.sourceStart, n.length);
            tail = q;
            n = n.next;
        }
        return head;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Region r = this;
        do {
            if (r != this) {
                buf.append(',');
            }
            buf.append(r.resultStart);
            buf.append('-');
            buf.append(r.resultStart + r.length);
        } while ((r = r.next) != null);
        return buf.toString();
    }
}

