/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.api;

import io.cucumber.pro.shaded.org.eclipse.jgit.api.GitCommand;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.GitAPIException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.JGitInternalException;
import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.NoFilepatternException;
import io.cucumber.pro.shaded.org.eclipse.jgit.dircache.DirCache;
import io.cucumber.pro.shaded.org.eclipse.jgit.dircache.DirCacheBuildIterator;
import io.cucumber.pro.shaded.org.eclipse.jgit.dircache.DirCacheBuilder;
import io.cucumber.pro.shaded.org.eclipse.jgit.events.WorkingTreeModifiedEvent;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.JGitText;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.FileMode;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import io.cucumber.pro.shaded.org.eclipse.jgit.treewalk.TreeWalk;
import io.cucumber.pro.shaded.org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public class RmCommand
extends GitCommand<DirCache> {
    private Collection<String> filepatterns = new LinkedList<String>();
    private boolean cached = false;

    public RmCommand(Repository repo) {
        super(repo);
    }

    public RmCommand addFilepattern(String filepattern) {
        this.checkCallable();
        this.filepatterns.add(filepattern);
        return this;
    }

    public RmCommand setCached(boolean cached) {
        this.checkCallable();
        this.cached = cached;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DirCache call() throws GitAPIException, NoFilepatternException {
        if (this.filepatterns.isEmpty()) {
            throw new NoFilepatternException(JGitText.get().atLeastOnePatternIsRequired);
        }
        this.checkCallable();
        DirCache dc = null;
        ArrayList<String> actuallyDeletedFiles = new ArrayList<String>();
        try (TreeWalk tw = new TreeWalk(this.repo);){
            dc = this.repo.lockDirCache();
            DirCacheBuilder builder = dc.builder();
            tw.reset();
            tw.setRecursive(true);
            tw.setFilter(PathFilterGroup.createFromStrings(this.filepatterns));
            tw.addTree(new DirCacheBuildIterator(builder));
            while (tw.next()) {
                FileMode mode;
                if (this.cached || (mode = tw.getFileMode(0)).getObjectType() != 3) continue;
                String relativePath = tw.getPathString();
                File path = new File(this.repo.getWorkTree(), relativePath);
                if (!this.delete(path)) continue;
                actuallyDeletedFiles.add(relativePath);
            }
            builder.commit();
            this.setCallable(false);
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().exceptionCaughtDuringExecutionOfRmCommand, e);
        }
        finally {
            try {
                if (dc != null) {
                    dc.unlock();
                }
            }
            finally {
                if (!actuallyDeletedFiles.isEmpty()) {
                    this.repo.fireEvent(new WorkingTreeModifiedEvent(null, actuallyDeletedFiles));
                }
            }
        }
        return dc;
    }

    private boolean delete(File p) {
        boolean deleted = false;
        while (p != null && !p.equals(this.repo.getWorkTree()) && p.delete()) {
            deleted = true;
            p = p.getParentFile();
        }
        return deleted;
    }
}

