/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.api;

import io.cucumber.pro.shaded.org.eclipse.jgit.api.errors.GitAPIException;
import io.cucumber.pro.shaded.org.eclipse.jgit.internal.JGitText;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Repository;
import java.text.MessageFormat;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class GitCommand<T>
implements Callable<T> {
    protected final Repository repo;
    private AtomicBoolean callable = new AtomicBoolean(true);

    protected GitCommand(Repository repo) {
        this.repo = repo;
    }

    public Repository getRepository() {
        return this.repo;
    }

    protected void setCallable(boolean callable) {
        this.callable.set(callable);
    }

    protected void checkCallable() {
        if (!this.callable.get()) {
            throw new IllegalStateException(MessageFormat.format(JGitText.get().commandWasCalledInTheWrongState, this.getClass().getName()));
        }
    }

    @Override
    public abstract T call() throws GitAPIException;
}

