/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.results;

import cucumber.runtime.CucumberException;
import io.cucumber.pro.Env;
import io.cucumber.pro.Logger;
import io.cucumber.pro.results.ResultsPublisher;
import io.cucumber.pro.shaded.org.apache.http.HttpEntity;
import io.cucumber.pro.shaded.org.apache.http.HttpResponse;
import io.cucumber.pro.shaded.org.apache.http.StatusLine;
import io.cucumber.pro.shaded.org.apache.http.auth.AuthScope;
import io.cucumber.pro.shaded.org.apache.http.auth.UsernamePasswordCredentials;
import io.cucumber.pro.shaded.org.apache.http.client.HttpClient;
import io.cucumber.pro.shaded.org.apache.http.client.config.RequestConfig;
import io.cucumber.pro.shaded.org.apache.http.client.methods.HttpPost;
import io.cucumber.pro.shaded.org.apache.http.conn.ConnectTimeoutException;
import io.cucumber.pro.shaded.org.apache.http.conn.HttpHostConnectException;
import io.cucumber.pro.shaded.org.apache.http.entity.ContentType;
import io.cucumber.pro.shaded.org.apache.http.entity.mime.HttpMultipartMode;
import io.cucumber.pro.shaded.org.apache.http.entity.mime.MultipartEntityBuilder;
import io.cucumber.pro.shaded.org.apache.http.entity.mime.content.AbstractContentBody;
import io.cucumber.pro.shaded.org.apache.http.entity.mime.content.FileBody;
import io.cucumber.pro.shaded.org.apache.http.entity.mime.content.StringBody;
import io.cucumber.pro.shaded.org.apache.http.impl.client.BasicCredentialsProvider;
import io.cucumber.pro.shaded.org.apache.http.impl.client.HttpClientBuilder;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;

class HTTPResultsPublisher
implements ResultsPublisher {
    private static final String PART_ENV = "env";
    private static final String PART_PAYLOAD = "payload";
    private static final String PART_PROFILE_NAME = "profileName";
    private static final String CONTENT_TYPE_CUCUMBER_JAVA_RESULTS_JSON = "application/x.cucumber.java.results+json";
    private final String url;
    private final String authToken;
    private final Env env;
    private final Logger logger;

    HTTPResultsPublisher(String url, Env env, Logger logger) {
        this.url = url;
        this.env = env;
        this.authToken = env.get("CUCUMBER_PRO_TOKEN", null);
        this.logger = logger;
    }

    @Override
    public void publish(File resultsJsonFile, String envString, String profileName) {
        HttpClient client = this.buildHttpClient();
        HttpPost post = new HttpPost(URI.create(this.url));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        try {
            builder.addPart(PART_ENV, new MemoryFileBody("env.txt", envString, ContentType.TEXT_PLAIN));
            builder.addPart(PART_PAYLOAD, new FileBody(resultsJsonFile, ContentType.create(CONTENT_TYPE_CUCUMBER_JAVA_RESULTS_JSON, "UTF-8")));
            builder.addPart(PART_PROFILE_NAME, new StringBody(profileName, ContentType.TEXT_PLAIN));
            HttpEntity entity = builder.build();
            post.setEntity(entity);
            HttpResponse response = client.execute(post);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode < 200 || statusCode >= 400) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                response.getEntity().writeTo(baos);
                String responseBody = new String(baos.toByteArray(), "UTF-8");
                String suggestion = "";
                if (statusCode == 401) {
                    suggestion = String.format("You need to define the %s environment variable", "CUCUMBER_PRO_TOKEN");
                }
                if (statusCode == 403) {
                    suggestion = String.format("You need to change the value of the %s environment variable", "CUCUMBER_PRO_TOKEN");
                }
                throw new CucumberException(String.format("Failed to publish results to Cucumber Pro URL: %s, Status: %s\n%s\n%s", this.url, statusLine, responseBody, suggestion));
            }
            this.logger.log(Logger.Level.INFO, "Published results to Cucumber Pro: " + this.url, new Object[0]);
        }
        catch (ConnectTimeoutException | HttpHostConnectException e) {
            if (this.env.getBoolean("CUCUMBER_PRO_IGNORE_CONNECTION_ERROR", false)) {
                this.logger.log(Logger.Level.WARN, "Failed to publish results to %s\n", this.url);
            }
            throw new CucumberException(String.format("Failed to publish results to %s\nYou can define %s=true to treat this as a warning instead of an error", this.url, "CUCUMBER_PRO_IGNORE_CONNECTION_ERROR"), (Throwable)e);
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    private HttpClient buildHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        int timeout = this.env.getInt("CUCUMBER_PRO_CONNECTION_TIMEOUT", 5000);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        if (this.authToken != null) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.authToken, "");
            provider.setCredentials(AuthScope.ANY, credentials);
            httpClientBuilder.setDefaultCredentialsProvider(provider);
        }
        return httpClientBuilder.build();
    }

    private class MemoryFileBody
    extends AbstractContentBody {
        private final String filename;
        private final byte[] data;

        MemoryFileBody(String filename, String data, ContentType contentType) throws UnsupportedEncodingException {
            super(contentType);
            this.filename = filename;
            this.data = data.getBytes("UTF-8");
        }

        @Override
        public String getFilename() {
            return this.filename;
        }

        @Override
        public void writeTo(OutputStream outputStream) throws IOException {
            outputStream.write(this.data);
        }

        @Override
        public String getTransferEncoding() {
            return "UTF-8";
        }

        @Override
        public long getContentLength() {
            return this.data.length;
        }
    }
}

