/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.shaded.org.eclipse.jgit.ignore;

import io.cucumber.pro.shaded.org.eclipse.jgit.ignore.FastIgnoreRule;
import io.cucumber.pro.shaded.org.eclipse.jgit.lib.Constants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class IgnoreNode {
    private final List<FastIgnoreRule> rules;

    public IgnoreNode() {
        this.rules = new ArrayList<FastIgnoreRule>();
    }

    public IgnoreNode(List<FastIgnoreRule> rules) {
        this.rules = rules;
    }

    public void parse(InputStream in) throws IOException {
        String txt;
        BufferedReader br = IgnoreNode.asReader(in);
        while ((txt = br.readLine()) != null) {
            FastIgnoreRule rule;
            if (txt.length() <= 0 || txt.startsWith("#") || txt.equals("/") || (rule = new FastIgnoreRule(txt)).isEmpty()) continue;
            this.rules.add(rule);
        }
    }

    private static BufferedReader asReader(InputStream in) {
        return new BufferedReader(new InputStreamReader(in, Constants.CHARSET));
    }

    public List<FastIgnoreRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public MatchResult isIgnored(String entryPath, boolean isDirectory) {
        return this.isIgnored(entryPath, isDirectory, false);
    }

    public MatchResult isIgnored(String entryPath, boolean isDirectory, boolean negateFirstMatch) {
        if (this.rules.isEmpty()) {
            if (negateFirstMatch) {
                return MatchResult.CHECK_PARENT_NEGATE_FIRST_MATCH;
            }
            return MatchResult.CHECK_PARENT;
        }
        for (int i = this.rules.size() - 1; i > -1; --i) {
            FastIgnoreRule rule = this.rules.get(i);
            if (!rule.isMatch(entryPath, isDirectory)) continue;
            if (rule.getResult()) {
                if (negateFirstMatch) {
                    negateFirstMatch = false;
                    continue;
                }
                return MatchResult.IGNORED;
            }
            if (negateFirstMatch) {
                return MatchResult.NOT_IGNORED;
            }
            negateFirstMatch = true;
        }
        if (negateFirstMatch) {
            return MatchResult.CHECK_PARENT_NEGATE_FIRST_MATCH;
        }
        return MatchResult.CHECK_PARENT;
    }

    public String toString() {
        return this.rules.toString();
    }

    public static enum MatchResult {
        NOT_IGNORED,
        IGNORED,
        CHECK_PARENT,
        CHECK_PARENT_NEGATE_FIRST_MATCH;

    }
}

