/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro;

import io.cucumber.pro.Env;

public interface Logger {
    public void log(Level var1, String var2, Object ... var3);

    public static class SystemLogger
    implements Logger {
        private final Level level;

        public SystemLogger(Env env) {
            this.level = Level.valueOf(env.get("CUCUMBER_PRO_LOG_LEVEL", Level.WARN.toString()));
        }

        @Override
        public void log(Level level, String message, Object ... args) {
            if (level.value >= this.level.value) {
                System.out.print((Object)level);
                System.out.print(": ");
                System.out.format(message, args);
                System.out.print("\n");
            }
        }
    }

    public static enum Level {
        DEBUG(0),
        INFO(1),
        WARN(2),
        ERROR(3),
        FATAL(4);

        private final int value;

        private Level(int value) {
            this.value = value;
        }
    }
}

