/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.revision.jgit;

import cucumber.runtime.CucumberException;
import io.cucumber.pro.revision.RevisionProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;

public class JGitRevisionProvider
implements RevisionProvider {
    private final Repository repository;

    public JGitRevisionProvider() {
        this(Paths.get(System.getProperty("user.dir"), new String[0]));
    }

    JGitRevisionProvider(Path rootPath) {
        FileRepositoryBuilder builder = new FileRepositoryBuilder();
        try {
            this.repository = ((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)builder.readEnvironment()).findGitDir(rootPath.toFile())).setMustExist(true)).build();
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
    }

    @Override
    public String getRevision() {
        try {
            return this.repository.exactRef("HEAD").getObjectId().getName();
        }
        catch (IOException e) {
            throw new CucumberException((Throwable)e);
        }
    }
}

