/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.revision.git;

import io.cucumber.pro.revision.RevisionProvider;
import io.cucumber.pro.revision.git.Exec;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class GitRevisionProvider
implements RevisionProvider {
    private final Path rootPath;
    private final Exec exec;

    public GitRevisionProvider() {
        this(Paths.get(System.getProperty("user.dir"), new String[0]));
    }

    GitRevisionProvider(Path rootPath) {
        this.rootPath = rootPath;
        this.exec = new Exec(rootPath);
    }

    public static GitRevisionProvider detect(Path directory) {
        Path workingCopyRoot = null;
        while (directory != null) {
            Path dotGit = directory.resolve(".git");
            if (Files.isDirectory(dotGit, new LinkOption[0])) {
                workingCopyRoot = directory;
            }
            directory = directory.getParent();
        }
        return workingCopyRoot != null ? new GitRevisionProvider(workingCopyRoot) : null;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    @Override
    public String getRevision() {
        return this.exec.cmd("git rev-parse HEAD").get(0);
    }
}

