/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.results;

import io.cucumber.pro.Env;
import io.cucumber.pro.Logger;
import io.cucumber.pro.activation.EnvActivation;
import io.cucumber.pro.metadata.MetadataFactory;
import io.cucumber.pro.results.CucumberProResultsUrlBuilder;
import io.cucumber.pro.results.HTTPResultsPublisher;
import io.cucumber.pro.results.NullResultsPublisher;
import io.cucumber.pro.results.ResultsPublisher;
import io.cucumber.pro.revision.RevisionProviderFactory;

public class ResultsPublisherFactory {
    public static ResultsPublisher create(Env env, Logger logger) {
        boolean isActive = new EnvActivation(env).isActive();
        if (!isActive) {
            return new NullResultsPublisher(logger, null);
        }
        String projectName = MetadataFactory.create(env).getProjectName();
        if (projectName == null) {
            String message = String.format("Project name missing. Either define an environment variable called %s or create %s with key %s", "CUCUMBER_PRO_PROJECT_NAME", ".cucumberpro.yml", "project_name");
            return new NullResultsPublisher(logger, message);
        }
        String revision = RevisionProviderFactory.create(env).getRevision();
        String url = CucumberProResultsUrlBuilder.buildCucumberProUrl(env, projectName, revision);
        return new HTTPResultsPublisher(url, env, Logger.System);
    }
}

