/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.results;

import io.cucumber.pro.Env;
import io.cucumber.pro.Logger;
import io.cucumber.pro.results.ResultsPublisher;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;

class HTTPResultsPublisher
implements ResultsPublisher {
    private static final String PART_ENV = "env";
    private static final String PART_PAYLOAD = "payload";
    private static final String PART_PROFILE_NAME = "profileName";
    private static final String CONTENT_TYPE_CUCUMBER_JAVA_RESULTS_JSON = "application/x.cucumber.java.results+json";
    private final String url;
    private final String authToken;
    private final Env env;
    private final Logger logger;

    HTTPResultsPublisher(String url, Env env, Logger logger) {
        this.url = url;
        this.env = env;
        this.authToken = env.get("CUCUMBER_PRO_TOKEN", null);
        this.logger = logger;
    }

    @Override
    public void publish(File resultsJsonFile, String envString, String profileName) {
        HttpClient client = this.buildHttpClient();
        HttpPost post = new HttpPost(URI.create(this.url));
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
        try {
            builder.addPart(PART_ENV, (ContentBody)new MemoryFileBody("env.txt", envString, ContentType.TEXT_PLAIN));
            builder.addPart(PART_PAYLOAD, (ContentBody)new FileBody(resultsJsonFile, ContentType.create((String)CONTENT_TYPE_CUCUMBER_JAVA_RESULTS_JSON, (String)"UTF-8")));
            builder.addPart(PART_PROFILE_NAME, (ContentBody)new StringBody(profileName, ContentType.TEXT_PLAIN));
            HttpEntity entity = builder.build();
            post.setEntity(entity);
            HttpResponse response = client.execute((HttpUriRequest)post);
            StatusLine statusLine = response.getStatusLine();
            int statusCode = statusLine.getStatusCode();
            if (statusCode < 200 || statusCode >= 400) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                response.getEntity().writeTo((OutputStream)baos);
                String responseBody = new String(baos.toByteArray(), "UTF-8");
                String suggestion = "";
                if (statusCode == 401) {
                    suggestion = String.format("You need to define the %s environment variable", "CUCUMBER_PRO_TOKEN");
                }
                if (statusCode == 403) {
                    suggestion = String.format("You need to change the value of the %s environment variable", "CUCUMBER_PRO_TOKEN");
                }
                throw new RuntimeException(String.format("Failed to publish results to Cucumber Pro URL: %s, Status: %s\n%s\n%s", this.url, statusLine, responseBody, suggestion));
            }
            this.logger.info("Published results to Cucumber Pro: " + this.url, new Object[0]);
        }
        catch (HttpHostConnectException e) {
            if (this.env.getBoolean("CUCUMBER_PRO_IGNORE_CONNECTION_ERROR", false)) {
                this.logger.warn("Failed to publish results to %s\n", this.url);
            }
            throw new RuntimeException(String.format("Failed to publish results to %s\nYou can define %s=true to treat this as a warning instead of an error", this.url, "CUCUMBER_PRO_IGNORE_CONNECTION_ERROR"), e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpClient buildHttpClient() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        int timeout = this.env.getInt("CUCUMBER_PRO_CONNECTION_TIMEOUT", 5000);
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout).setSocketTimeout(timeout).build();
        httpClientBuilder.setDefaultRequestConfig(requestConfig);
        if (this.authToken != null) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.authToken, "");
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)provider);
        }
        return httpClientBuilder.build();
    }

    private class MemoryFileBody
    extends AbstractContentBody {
        private final String filename;
        private final byte[] data;

        MemoryFileBody(String filename, String data, ContentType contentType) throws UnsupportedEncodingException {
            super(contentType);
            this.filename = filename;
            this.data = data.getBytes("UTF-8");
        }

        public String getFilename() {
            return this.filename;
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            outputStream.write(this.data);
        }

        public String getTransferEncoding() {
            return "UTF-8";
        }

        public long getContentLength() {
            return this.data.length;
        }
    }
}

