/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro.metadata;

import io.cucumber.pro.metadata.Metadata;
import io.cucumber.pro.metadata.NullMetadata;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public class YamlMetadata
implements Metadata {
    public static final String YAML_FILE_NAME = ".cucumberpro.yml";
    public static final String PROJECT_NAME_FIELD = "project_name";
    private static final Yaml YAML = new Yaml();
    private final Map metadata;

    YamlMetadata(Reader source) {
        this.metadata = (Map)YAML.load(source);
    }

    static Metadata create() {
        File yamlFile = new File(YAML_FILE_NAME);
        if (!yamlFile.isFile()) {
            return new NullMetadata();
        }
        try {
            return new YamlMetadata(new InputStreamReader((InputStream)new FileInputStream(yamlFile), "UTF-8"));
        }
        catch (IOException e1) {
            return new NullMetadata();
        }
    }

    @Override
    public String getProjectName() {
        return (String)this.metadata.get(PROJECT_NAME_FIELD);
    }
}

