/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.pro;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URITemplate {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\{([^}]+)}");
    private final String template;

    public URITemplate(String template) {
        this.template = template;
    }

    public String expand(Map<String, String> values) {
        Matcher matcher = PARAMETER_PATTERN.matcher(this.template);
        StringBuffer format = new StringBuffer();
        ArrayList<String> arguments = new ArrayList<String>();
        while (matcher.find()) {
            String variableName = matcher.group(1);
            matcher.appendReplacement(format, "%s");
            String argument = values.get(variableName);
            if (argument == null) {
                throw new RuntimeException(String.format("Missing argument \"%s\". Template: %s Arguments: %s", variableName, this.template, values));
            }
            arguments.add(argument);
        }
        matcher.appendTail(format);
        Object[] args = arguments.toArray(new String[arguments.size()]);
        return String.format(format.toString(), args);
    }
}

