/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.htmlformatter;

import io.cucumber.messages.internal.com.fasterxml.jackson.annotation.JsonInclude;
import io.cucumber.messages.internal.com.fasterxml.jackson.databind.json.JsonMapper;
import io.cucumber.messages.types.Envelope;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class MessagesToHtmlWriter
implements AutoCloseable {
    private final JsonMapper jsonPrinter = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().serializationInclusion(JsonInclude.Include.NON_NULL)).build();
    private final String template;
    private final Writer writer;
    private boolean preMessageWritten = false;
    private boolean postMessageWritten = false;
    private boolean firstMessageWritten = false;
    private boolean streamClosed = false;

    public MessagesToHtmlWriter(Writer writer) throws IOException {
        this.writer = writer;
        this.template = MessagesToHtmlWriter.readResource("index.mustache.html");
    }

    private void writePreMessage() throws IOException {
        MessagesToHtmlWriter.writeTemplateBetween(this.writer, this.template, null, "{{css}}");
        MessagesToHtmlWriter.writeResource(this.writer, "cucumber-react.css");
        MessagesToHtmlWriter.writeTemplateBetween(this.writer, this.template, "{{css}}", "{{messages}}");
    }

    private void writePostMessage() throws IOException {
        MessagesToHtmlWriter.writeTemplateBetween(this.writer, this.template, "{{messages}}", "{{script}}");
        MessagesToHtmlWriter.writeResource(this.writer, "cucumber-html.js");
        MessagesToHtmlWriter.writeTemplateBetween(this.writer, this.template, "{{script}}", null);
    }

    public void write(Envelope envelope) throws IOException {
        if (this.streamClosed) {
            throw new IOException("Stream closed");
        }
        if (!this.preMessageWritten) {
            this.writePreMessage();
            this.preMessageWritten = true;
        }
        if (!this.firstMessageWritten) {
            this.firstMessageWritten = true;
        } else {
            this.writer.write(",");
        }
        this.writer.write(this.jsonPrinter.writeValueAsString((Object)envelope));
    }

    @Override
    public void close() throws IOException {
        if (this.streamClosed) {
            return;
        }
        if (!this.preMessageWritten) {
            this.writePreMessage();
            this.preMessageWritten = true;
        }
        if (!this.postMessageWritten) {
            this.writePostMessage();
            this.postMessageWritten = true;
        }
        this.writer.close();
        this.streamClosed = true;
    }

    private static void writeTemplateBetween(Writer writer, String template, String begin, String end) throws IOException {
        int beginIndex = begin == null ? 0 : template.indexOf(begin) + begin.length();
        int endIndex = end == null ? template.length() : template.indexOf(end);
        writer.write(template.substring(beginIndex, endIndex));
    }

    private static void writeResource(Writer writer, String name) throws IOException {
        InputStream resource = MessagesToHtmlWriter.class.getResourceAsStream(name);
        Objects.requireNonNull(resource, name + " could not be loaded");
        BufferedReader reader = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));
        char[] buffer = new char[1024];
        int read = reader.read(buffer);
        while (read != -1) {
            writer.write(buffer, 0, read);
            read = reader.read(buffer);
        }
    }

    private static String readResource(String name) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8));){
            MessagesToHtmlWriter.writeResource(writer, name);
        }
        return new String(baos.toByteArray(), StandardCharsets.UTF_8);
    }
}

