/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.docstring;

import io.cucumber.docstring.CucumberDocStringException;
import io.cucumber.docstring.DocString;
import io.cucumber.docstring.DocStringType;
import io.cucumber.docstring.DocStringTypeRegistry;
import java.lang.reflect.Type;
import java.util.Objects;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class DocStringTypeRegistryDocStringConverter
implements DocString.DocStringConverter {
    private final DocStringTypeRegistry docStringTypeRegistry;

    public DocStringTypeRegistryDocStringConverter(DocStringTypeRegistry docStringTypeRegistry) {
        this.docStringTypeRegistry = Objects.requireNonNull(docStringTypeRegistry);
    }

    @Override
    public <T> T convert(DocString docString, Type targetType) {
        if (DocString.class.equals((Object)targetType)) {
            return (T)docString;
        }
        DocStringType docStringType = this.docStringTypeRegistry.lookupByContentType(docString.getContentType());
        if (docStringType != null) {
            return (T)docStringType.transform(docString.getContent());
        }
        docStringType = this.docStringTypeRegistry.lookupByType(targetType);
        if (docStringType != null) {
            return (T)docStringType.transform(docString.getContent());
        }
        if (docString.getContentType() == null) {
            throw new CucumberDocStringException(String.format("It appears you did not register docstring type for %s", targetType.getTypeName()));
        }
        throw new CucumberDocStringException(String.format("It appears you did not register docstring type for '%s' or %s", docString.getContentType(), targetType.getTypeName()));
    }
}

