/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.datatable;

import io.cucumber.datatable.CucumberDataTableException;
import io.cucumber.datatable.DataTable;
import io.cucumber.datatable.DataTableType;
import io.cucumber.datatable.DataTableTypeRegistry;
import io.cucumber.datatable.TypeFactory;
import io.cucumber.datatable.UndefinedDataTableTypeException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE)
public final class DataTableTypeRegistryTableConverter
implements DataTable.TableConverter {
    private final DataTableTypeRegistry registry;

    public DataTableTypeRegistryTableConverter(DataTableTypeRegistry registry) {
        this.registry = registry;
    }

    @Override
    public <T> T convert(DataTable dataTable, Type type) {
        return this.convert(dataTable, type, false);
    }

    @Override
    public <T> T convert(DataTable dataTable, Type type, boolean transposed) {
        TypeFactory.JavaType javaType;
        DataTableType tableType;
        Objects.requireNonNull(dataTable, "dataTable may not be null");
        Objects.requireNonNull(type, "type may not be null");
        if (transposed) {
            dataTable = dataTable.transpose();
        }
        if ((tableType = this.registry.lookupTableTypeByType(javaType = TypeFactory.constructType(type))) != null) {
            return (T)tableType.transform(dataTable.cells());
        }
        if (type.equals(DataTable.class)) {
            return (T)dataTable;
        }
        if (javaType instanceof TypeFactory.MapType) {
            TypeFactory.MapType mapType = (TypeFactory.MapType)javaType;
            return (T)this.toMap(dataTable, mapType.getKeyType(), mapType.getValueType());
        }
        if (javaType instanceof TypeFactory.OptionalType) {
            TypeFactory.OptionalType optionalType = (TypeFactory.OptionalType)javaType;
            T singleton = this.toSingleton(dataTable, optionalType.getElementType());
            return (T)Optional.ofNullable(singleton);
        }
        if (javaType instanceof TypeFactory.OtherType || javaType instanceof TypeFactory.Parameterized) {
            return this.toSingleton(dataTable, javaType);
        }
        assert (javaType instanceof TypeFactory.ListType);
        TypeFactory.ListType listType = (TypeFactory.ListType)javaType;
        TypeFactory.JavaType listElementType = listType.getElementType();
        if (listElementType instanceof TypeFactory.MapType) {
            TypeFactory.MapType mapElement = (TypeFactory.MapType)listElementType;
            return (T)this.toMaps(dataTable, mapElement.getKeyType(), mapElement.getValueType());
        }
        if (listElementType instanceof TypeFactory.ListType) {
            TypeFactory.ListType listElement = (TypeFactory.ListType)listElementType;
            return (T)this.toLists(dataTable, listElement.getElementType());
        }
        assert (listElementType instanceof TypeFactory.OtherType || listElementType instanceof TypeFactory.OptionalType || listElementType instanceof TypeFactory.Parameterized);
        return (T)this.toList(dataTable, listElementType);
    }

    private <T> T toSingleton(DataTable dataTable, Type type) {
        if (dataTable.isEmpty()) {
            return null;
        }
        ListOrProblems<T> result = this.toListOrProblems(dataTable, type);
        if (result.hasList()) {
            List<T> singletonList = result.getList();
            if (singletonList.size() == 1) {
                return singletonList.get(0);
            }
            throw CucumberDataTableException.cantConvertTo(type, "The table contained more then one item: " + singletonList);
        }
        throw UndefinedDataTableTypeException.singletonNoConverterDefined(type, result.getProblems());
    }

    @Override
    public <T> List<T> toList(DataTable dataTable, Type itemType) {
        Objects.requireNonNull(dataTable, "dataTable may not be null");
        Objects.requireNonNull(itemType, "itemType may not be null");
        if (dataTable.isEmpty()) {
            return Collections.emptyList();
        }
        ListOrProblems<T> result = this.toListOrProblems(dataTable, itemType);
        if (result.hasList()) {
            return Collections.unmodifiableList(result.getList());
        }
        throw UndefinedDataTableTypeException.listNoConverterDefined(itemType, result.getProblems());
    }

    private <T> ListOrProblems<T> toListOrProblems(DataTable dataTable, Type itemType) {
        ArrayList<String> problems = new ArrayList<String>();
        List<List<String>> cells = dataTable.cells();
        boolean singleColumn = dataTable.width() == 1;
        boolean mayHaveHeader = dataTable.height() > 1;
        DataTableType entryOrRowValueType = this.registry.lookupRowTypeByType(itemType);
        if (entryOrRowValueType != null) {
            return ListOrProblems.list((List)entryOrRowValueType.transform(cells));
        }
        problems.add(UndefinedDataTableTypeException.problemNoTableEntryOrTableRowTransformer(itemType));
        DataTableType cellValueType = this.registry.lookupCellTypeByType(itemType);
        if (cellValueType != null) {
            if (singleColumn) {
                return ListOrProblems.list(DataTableTypeRegistryTableConverter.unpack((List)cellValueType.transform(cells)));
            }
            problems.add(0, UndefinedDataTableTypeException.problemTableTooWideForTableCellTransformer(itemType));
        } else if (singleColumn) {
            problems.add(UndefinedDataTableTypeException.problemNoTableCellTransformer(itemType));
        }
        DataTableType defaultTableEntryType = this.registry.getDefaultTableEntryTransformer(itemType);
        if (defaultTableEntryType != null) {
            if (mayHaveHeader) {
                return ListOrProblems.list((List)defaultTableEntryType.transform(cells));
            }
            problems.add(UndefinedDataTableTypeException.problemTableTooShortForDefaultTableEntry(itemType));
        } else if (mayHaveHeader) {
            problems.add(UndefinedDataTableTypeException.problemNoDefaultTableEntryTransformer(itemType));
        }
        DataTableType defaultCellValueType = this.registry.getDefaultTableCellTransformer(itemType);
        if (defaultCellValueType != null) {
            if (singleColumn) {
                return ListOrProblems.list(DataTableTypeRegistryTableConverter.unpack((List)defaultCellValueType.transform(cells)));
            }
            problems.add(0, UndefinedDataTableTypeException.problemTableTooWideForDefaultTableCell(itemType));
        } else if (singleColumn) {
            problems.add(UndefinedDataTableTypeException.problemNoDefaultTableCellTransformer(itemType));
        }
        return ListOrProblems.problems(problems);
    }

    @Override
    public <T> List<List<T>> toLists(DataTable dataTable, Type itemType) {
        Objects.requireNonNull(dataTable, "dataTable may not be null");
        Objects.requireNonNull(itemType, "itemType may not be null");
        if (dataTable.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> problems = new ArrayList<String>();
        DataTableType tableType = this.registry.lookupCellTypeByType(itemType);
        if (tableType != null) {
            return Collections.unmodifiableList((List)tableType.transform(dataTable.cells()));
        }
        problems.add(UndefinedDataTableTypeException.problemNoTableCellTransformer(itemType));
        tableType = this.registry.getDefaultTableCellTransformer(itemType);
        if (tableType != null) {
            return Collections.unmodifiableList((List)tableType.transform(dataTable.cells()));
        }
        problems.add(UndefinedDataTableTypeException.problemNoDefaultTableCellTransformer(itemType));
        throw UndefinedDataTableTypeException.listsNoConverterDefined(itemType, problems);
    }

    @Override
    public <K, V> Map<K, V> toMap(DataTable dataTable, Type keyType, Type valueType) {
        Objects.requireNonNull(dataTable, "dataTable may not be null");
        Objects.requireNonNull(keyType, "keyType may not be null");
        Objects.requireNonNull(valueType, "valueType may not be null");
        if (dataTable.isEmpty()) {
            return Collections.emptyMap();
        }
        DataTable keyColumn = dataTable.columns(0, 1);
        DataTable valueColumns = dataTable.columns(1);
        String firstHeaderCell = keyColumn.cell(0, 0);
        boolean firstHeaderCellIsBlank = firstHeaderCell == null || firstHeaderCell.isEmpty();
        List<K> keys = this.convertEntryKeys(keyType, keyColumn, valueType, firstHeaderCellIsBlank);
        if (valueColumns.isEmpty()) {
            return DataTableTypeRegistryTableConverter.createMap(keyType, keys, valueType, Collections.nCopies(keys.size(), null));
        }
        boolean keysImplyTableRowTransformer = keys.size() == dataTable.height() - 1;
        List<V> values = this.convertEntryValues(valueColumns, keyType, valueType, keysImplyTableRowTransformer);
        if (keys.size() != values.size()) {
            throw CucumberDataTableException.keyValueMismatchException(firstHeaderCellIsBlank, keys.size(), keyType, values.size(), valueType);
        }
        return DataTableTypeRegistryTableConverter.createMap(keyType, keys, valueType, values);
    }

    private static <K, V> Map<K, V> createMap(Type keyType, List<K> keys, Type valueType, List<V> values) {
        Iterator<K> keyIterator = keys.iterator();
        Iterator<V> valueIterator = values.iterator();
        LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
        while (keyIterator.hasNext() && valueIterator.hasNext()) {
            K key = keyIterator.next();
            V value = valueIterator.next();
            if (result.containsKey(key)) {
                Object wouldBeReplaced = result.get(key);
                throw CucumberDataTableException.duplicateKeyException(keyType, valueType, key, value, wouldBeReplaced);
            }
            result.put(key, value);
        }
        return Collections.unmodifiableMap(result);
    }

    private <K> List<K> convertEntryKeys(Type keyType, DataTable keyColumn, Type valueType, boolean firstHeaderCellIsBlank) {
        if (firstHeaderCellIsBlank) {
            DataTable keyColumnRows = keyColumn.subTable(1, 0);
            return this.convertEntryKeyColumnRows(keyType, valueType, keyColumnRows);
        }
        ListOrProblems listOrProblems = this.toListOrProblems(keyColumn, keyType);
        if (listOrProblems.hasList()) {
            return listOrProblems.getList();
        }
        throw UndefinedDataTableTypeException.mapNoConverterDefined(keyType, valueType, listOrProblems.getProblems());
    }

    private <K> List<K> convertEntryKeyColumnRows(Type keyType, Type valueType, DataTable keyColumnRows) {
        ArrayList<String> problems = new ArrayList<String>(2);
        DataTableType keyConverter = this.registry.lookupCellTypeByType(keyType);
        if (keyConverter != null) {
            return DataTableTypeRegistryTableConverter.unpack((List)keyConverter.transform(keyColumnRows.cells()));
        }
        problems.add(UndefinedDataTableTypeException.problemNoTableCellTransformer(keyType));
        keyConverter = this.registry.getDefaultTableCellTransformer(keyType);
        if (keyConverter != null) {
            return DataTableTypeRegistryTableConverter.unpack((List)keyConverter.transform(keyColumnRows.cells()));
        }
        problems.add(UndefinedDataTableTypeException.problemNoDefaultTableCellTransformer(keyType));
        throw UndefinedDataTableTypeException.mapNoConverterDefined(keyType, valueType, problems);
    }

    private <V> List<V> convertEntryValues(DataTable dataTable, Type keyType, Type valueType, boolean keysImplyTableEntryTransformer) {
        ArrayList<String> problems = new ArrayList<String>();
        TypeFactory.JavaType javaType = TypeFactory.constructType(valueType);
        if (javaType instanceof TypeFactory.ListType) {
            TypeFactory.ListType listType = (TypeFactory.ListType)javaType;
            DataTableType cellValueConverter = this.registry.lookupCellTypeByType(listType.getElementType());
            if (cellValueConverter == null) {
                problems.add(UndefinedDataTableTypeException.problemNoTableCellTransformer(listType.getElementType()));
                cellValueConverter = this.registry.getDefaultTableCellTransformer(listType.getElementType());
            }
            if (cellValueConverter == null) {
                problems.add(UndefinedDataTableTypeException.problemNoDefaultTableCellTransformer(listType.getElementType()));
                throw UndefinedDataTableTypeException.mapNoConverterDefined(keyType, valueType, problems);
            }
            return (List)cellValueConverter.transform(dataTable.cells());
        }
        if (javaType instanceof TypeFactory.MapType) {
            TypeFactory.MapType mapType = (TypeFactory.MapType)javaType;
            return this.toMaps(dataTable, mapType.getKeyType(), mapType.getValueType());
        }
        DataTableType entryValueConverter = this.registry.lookupRowTypeByType(valueType);
        if (entryValueConverter != null) {
            return (List)entryValueConverter.transform(dataTable.cells());
        }
        problems.add(UndefinedDataTableTypeException.problemNoTableEntryTransformer(valueType));
        if (keysImplyTableEntryTransformer) {
            DataTableType defaultEntryValueConverter = this.registry.getDefaultTableEntryTransformer(valueType);
            if (defaultEntryValueConverter != null) {
                return (List)defaultEntryValueConverter.transform(dataTable.cells());
            }
            throw CucumberDataTableException.keysImplyTableEntryTransformer(keyType, valueType);
        }
        DataTableType cellValueConverter = this.registry.lookupTableTypeByType(TypeFactory.aListOf(TypeFactory.aListOf(valueType)));
        if (cellValueConverter != null) {
            return DataTableTypeRegistryTableConverter.unpack((List)cellValueConverter.transform(dataTable.cells()));
        }
        problems.add(UndefinedDataTableTypeException.problemNoTableCellTransformer(valueType));
        DataTableType defaultCellValueConverter = this.registry.getDefaultTableCellTransformer(valueType);
        if (defaultCellValueConverter != null) {
            return DataTableTypeRegistryTableConverter.unpack((List)defaultCellValueConverter.transform(dataTable.cells()));
        }
        problems.add(UndefinedDataTableTypeException.problemNoDefaultTableCellTransformer(valueType));
        throw UndefinedDataTableTypeException.mapNoConverterDefined(keyType, valueType, problems);
    }

    @Override
    public <K, V> List<Map<K, V>> toMaps(DataTable dataTable, Type keyType, Type valueType) {
        Objects.requireNonNull(dataTable, "dataTable may not be null");
        Objects.requireNonNull(keyType, "keyType may not be null");
        Objects.requireNonNull(valueType, "valueType may not be null");
        if (dataTable.isEmpty()) {
            return Collections.emptyList();
        }
        DataTableType keyConverter = this.registry.lookupCellTypeByType(keyType);
        DataTableType valueConverter = this.registry.lookupCellTypeByType(valueType);
        ArrayList<String> problems = new ArrayList<String>();
        if (keyConverter == null) {
            problems.add(UndefinedDataTableTypeException.problemNoTableCellTransformer(keyType));
        }
        if (valueConverter == null) {
            problems.add(UndefinedDataTableTypeException.problemNoTableCellTransformer(valueType));
        }
        if (!problems.isEmpty()) {
            throw UndefinedDataTableTypeException.mapsNoConverterDefined(keyType, valueType, problems);
        }
        DataTable header = dataTable.rows(0, 1);
        ArrayList result = new ArrayList();
        List keys = DataTableTypeRegistryTableConverter.unpack((List)keyConverter.transform(header.cells()));
        DataTable rows = dataTable.rows(1);
        if (rows.isEmpty()) {
            return Collections.emptyList();
        }
        List transform = (List)valueConverter.transform(rows.cells());
        for (List values : transform) {
            result.add(DataTableTypeRegistryTableConverter.createMap(keyType, keys, valueType, values));
        }
        return Collections.unmodifiableList(result);
    }

    private static <T> List<T> unpack(List<List<T>> cells) {
        ArrayList<T> unpacked = new ArrayList<T>(cells.size());
        for (List<T> row : cells) {
            unpacked.addAll(row);
        }
        return unpacked;
    }

    private static final class ListOrProblems<T> {
        private final List<T> list;
        private final List<String> problems;

        private ListOrProblems(List<T> list, List<String> problems) {
            this.list = list;
            this.problems = problems;
        }

        private static <T> ListOrProblems<T> problems(List<String> problems) {
            return new ListOrProblems<T>(null, problems);
        }

        private static <T> ListOrProblems<T> list(List<T> list) {
            return new ListOrProblems<T>(list, null);
        }

        public boolean hasList() {
            return this.list != null;
        }

        public List<T> getList() {
            return this.list;
        }

        public List<String> getProblems() {
            return this.problems;
        }
    }
}

