/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit.platform.engine;

import io.cucumber.junit.platform.engine.FeatureResolver;
import io.cucumber.junit.platform.engine.PickleDescriptor;
import java.util.Collection;
import java.util.function.Predicate;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.ClasspathResourceSelector;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DirectorySelector;
import org.junit.platform.engine.discovery.FileSelector;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.discovery.UniqueIdSelector;
import org.junit.platform.engine.discovery.UriSelector;

class DiscoverySelectorResolver {
    DiscoverySelectorResolver() {
    }

    void resolveSelectors(EngineDiscoveryRequest request, TestDescriptor engineDescriptor) {
        Predicate<String> packageFilter = this.buildPackageFilter(request);
        this.resolve(request, engineDescriptor, packageFilter);
        this.filter(engineDescriptor, packageFilter);
        this.pruneTree(engineDescriptor);
    }

    private Predicate<String> buildPackageFilter(EngineDiscoveryRequest request) {
        Filter packageFilter = Filter.composeFilters((Collection)request.getFiltersByType(PackageNameFilter.class));
        return packageFilter.toPredicate();
    }

    private void resolve(EngineDiscoveryRequest request, TestDescriptor engineDescriptor, Predicate<String> packageFilter) {
        FeatureResolver featureResolver = FeatureResolver.createFeatureResolver(engineDescriptor, packageFilter);
        request.getSelectorsByType(ClasspathRootSelector.class).forEach(featureResolver::resolveClasspathRoot);
        request.getSelectorsByType(ClasspathResourceSelector.class).forEach(featureResolver::resolveClasspathResource);
        request.getSelectorsByType(ClassSelector.class).forEach(featureResolver::resolveClass);
        request.getSelectorsByType(PackageSelector.class).forEach(featureResolver::resolvePackageResource);
        request.getSelectorsByType(FileSelector.class).forEach(featureResolver::resolveFile);
        request.getSelectorsByType(DirectorySelector.class).forEach(featureResolver::resolveDirectory);
        request.getSelectorsByType(UniqueIdSelector.class).forEach(featureResolver::resolveUniqueId);
        request.getSelectorsByType(UriSelector.class).forEach(featureResolver::resolveUri);
    }

    private void filter(TestDescriptor engineDescriptor, Predicate<String> packageFilter) {
        this.applyPackagePredicate(packageFilter, engineDescriptor);
    }

    private void applyPackagePredicate(Predicate<String> packageFilter, TestDescriptor engineDescriptor) {
        engineDescriptor.accept(descriptor -> {
            PickleDescriptor pickleDescriptor;
            if (descriptor instanceof PickleDescriptor && !this.includePickle(pickleDescriptor = (PickleDescriptor)descriptor, packageFilter)) {
                descriptor.removeFromHierarchy();
            }
        });
    }

    private boolean includePickle(PickleDescriptor pickleDescriptor, Predicate<String> packageFilter) {
        return pickleDescriptor.getPackage().map(packageFilter::test).orElse(true);
    }

    private void pruneTree(TestDescriptor rootDescriptor) {
        rootDescriptor.accept(TestDescriptor::prune);
    }
}

