/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java8;

import io.cucumber.core.backend.Located;
import io.cucumber.core.backend.SourceReference;
import io.cucumber.java8.Invoker;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.jodah.typetools.TypeResolver;

abstract class AbstractGlueDefinition
implements Located {
    private Object body;
    private Method method;
    private SourceReference sourceReference;
    final StackTraceElement location;

    AbstractGlueDefinition(Object body, StackTraceElement location) {
        this.updateClosure(body);
        this.location = Objects.requireNonNull(location);
    }

    void updateClosure(AbstractGlueDefinition other) {
        this.updateClosure(other.body);
    }

    private void updateClosure(Object body) {
        this.body = Objects.requireNonNull(body);
        this.method = AbstractGlueDefinition.getAcceptMethod(body.getClass());
    }

    void disposeClosure() {
        this.body = null;
        this.method = null;
    }

    private static Method getAcceptMethod(Class<?> bodyClass) {
        ArrayList<Method> acceptMethods = new ArrayList<Method>();
        for (Method method : bodyClass.getDeclaredMethods()) {
            if (method.isBridge() || method.isSynthetic() || !"accept".equals(method.getName())) continue;
            acceptMethods.add(method);
        }
        if (acceptMethods.size() != 1) {
            throw new IllegalStateException(String.format("Expected single 'accept' method on body class, found '%s'", acceptMethods));
        }
        return (Method)acceptMethods.get(0);
    }

    protected Object invokeMethod(Object ... args) {
        if (this.body == null) {
            throw new IllegalStateException("Can not execute scenario scoped glue when scenario has been disposed of");
        }
        return Invoker.invoke(this, this.body, this.method, args);
    }

    protected int getParameterCount() {
        return this.method.getParameterCount();
    }

    public final String getLocation() {
        return this.location.toString();
    }

    public final boolean isDefinedAt(StackTraceElement stackTraceElement) {
        return this.location.getFileName() != null && this.location.getFileName().equals(stackTraceElement.getFileName());
    }

    public Optional<SourceReference> getSourceReference() {
        return Optional.of(this.requireSourceReference());
    }

    SourceReference requireSourceReference() {
        if (this.sourceReference == null) {
            this.sourceReference = SourceReference.fromStackTraceElement((StackTraceElement)this.location);
        }
        return this.sourceReference;
    }

    Class<?>[] resolveRawArguments(Class<?> bodyClass, Class<?> body) {
        Class[] rawArguments;
        for (Class aClass : rawArguments = TypeResolver.resolveRawArguments(bodyClass, body)) {
            if (!TypeResolver.Unknown.class.equals((Object)aClass)) continue;
            throw new IllegalStateException("Could resolve the return type of the lambda at " + this.location.getFileName() + ":" + this.location.getLineNumber());
        }
        return rawArguments;
    }
}

