/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java8;

import io.cucumber.core.backend.Backend;
import io.cucumber.core.backend.Container;
import io.cucumber.core.backend.DataTableTypeDefinition;
import io.cucumber.core.backend.DefaultDataTableCellTransformerDefinition;
import io.cucumber.core.backend.DefaultDataTableEntryTransformerDefinition;
import io.cucumber.core.backend.DefaultParameterTransformerDefinition;
import io.cucumber.core.backend.DocStringTypeDefinition;
import io.cucumber.core.backend.Glue;
import io.cucumber.core.backend.HookDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.ParameterTypeDefinition;
import io.cucumber.core.backend.Snippet;
import io.cucumber.core.backend.StepDefinition;
import io.cucumber.core.resource.ClasspathScanner;
import io.cucumber.core.resource.ClasspathSupport;
import io.cucumber.java8.Java8Snippet;
import io.cucumber.java8.LambdaGlue;
import io.cucumber.java8.LambdaGlueRegistry;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

final class Java8Backend
implements Backend {
    private final Lookup lookup;
    private final Container container;
    private final ClasspathScanner classFinder;
    private final List<Class<? extends LambdaGlue>> lambdaGlueClasses = new ArrayList<Class<? extends LambdaGlue>>();
    private Glue glue;

    Java8Backend(Lookup lookup, Container container, Supplier<ClassLoader> classLoaderProvider) {
        this.container = container;
        this.lookup = lookup;
        this.classFinder = new ClasspathScanner(classLoaderProvider);
    }

    public void loadGlue(Glue glue, List<URI> gluePaths) {
        this.glue = glue;
        gluePaths.stream().filter(gluePath -> "classpath".equals(gluePath.getScheme())).map(ClasspathSupport::packageName).map(basePackageName -> this.classFinder.scanForSubClassesInPackage(basePackageName, LambdaGlue.class)).flatMap(Collection::stream).filter(glueClass -> !glueClass.isInterface()).filter(glueClass -> glueClass.getConstructors().length > 0).forEach(glueClass -> {
            this.container.addClass(glueClass);
            this.lambdaGlueClasses.add((Class<? extends LambdaGlue>)glueClass);
        });
    }

    public void buildWorld() {
        LambdaGlueRegistry.INSTANCE.set(new GlueAdaptor(this.glue));
        for (Class<? extends LambdaGlue> lambdaGlueClass : this.lambdaGlueClasses) {
            this.lookup.getInstance(lambdaGlueClass);
        }
    }

    public void disposeWorld() {
        LambdaGlueRegistry.INSTANCE.remove();
    }

    public Snippet getSnippet() {
        return new Java8Snippet();
    }

    private static final class GlueAdaptor
    implements LambdaGlueRegistry {
        private final Glue glue;

        private GlueAdaptor(Glue glue) {
            this.glue = glue;
        }

        @Override
        public void addStepDefinition(StepDefinition stepDefinition) {
            this.glue.addStepDefinition(stepDefinition);
        }

        @Override
        public void addBeforeStepHookDefinition(HookDefinition beforeStepHook) {
            this.glue.addBeforeStepHook(beforeStepHook);
        }

        @Override
        public void addAfterStepHookDefinition(HookDefinition afterStepHook) {
            this.glue.addAfterStepHook(afterStepHook);
        }

        @Override
        public void addBeforeHookDefinition(HookDefinition beforeHook) {
            this.glue.addBeforeHook(beforeHook);
        }

        @Override
        public void addAfterHookDefinition(HookDefinition afterHook) {
            this.glue.addAfterHook(afterHook);
        }

        @Override
        public void addDocStringType(DocStringTypeDefinition docStringType) {
            this.glue.addDocStringType(docStringType);
        }

        @Override
        public void addDataTableType(DataTableTypeDefinition dataTableType) {
            this.glue.addDataTableType(dataTableType);
        }

        @Override
        public void addParameterType(ParameterTypeDefinition parameterType) {
            this.glue.addParameterType(parameterType);
        }

        @Override
        public void addDefaultParameterTransformer(DefaultParameterTransformerDefinition defaultParameterTransformer) {
            this.glue.addDefaultParameterTransformer(defaultParameterTransformer);
        }

        @Override
        public void addDefaultDataTableCellTransformer(DefaultDataTableCellTransformerDefinition defaultDataTableCellTransformer) {
            this.glue.addDefaultDataTableCellTransformer(defaultDataTableCellTransformer);
        }

        @Override
        public void addDefaultDataTableEntryTransformer(DefaultDataTableEntryTransformerDefinition defaultDataTableEntryTransformer) {
            this.glue.addDefaultDataTableEntryTransformer(defaultDataTableEntryTransformer);
        }
    }
}

