/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.backend.Backend;
import io.cucumber.core.backend.Container;
import io.cucumber.core.backend.Glue;
import io.cucumber.core.backend.Lookup;
import io.cucumber.core.backend.Snippet;
import io.cucumber.core.resource.ClasspathScanner;
import io.cucumber.core.resource.ClasspathSupport;
import io.cucumber.java.GlueAdaptor;
import io.cucumber.java.JavaSnippet;
import io.cucumber.java.MethodScanner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;

final class JavaBackend
implements Backend {
    private final Lookup lookup;
    private final Container container;
    private final ClasspathScanner classFinder;

    JavaBackend(Lookup lookup, Container container, Supplier<ClassLoader> classLoaderSupplier) {
        this.lookup = lookup;
        this.container = container;
        this.classFinder = new ClasspathScanner(classLoaderSupplier);
    }

    public void loadGlue(Glue glue, List<URI> gluePaths) {
        GlueAdaptor glueAdaptor = new GlueAdaptor(this.lookup, glue);
        gluePaths.stream().filter(gluePath -> "classpath".equals(gluePath.getScheme())).map(ClasspathSupport::resourcePath).map(ClasspathSupport::resourceName).map(arg_0 -> ((ClasspathScanner)this.classFinder).scanForClassesInPackage(arg_0)).flatMap(Collection::stream).forEach(aGlueClass -> MethodScanner.scan(aGlueClass, (method, annotation) -> {
            this.container.addClass(method.getDeclaringClass());
            glueAdaptor.addDefinition((Method)method, (Annotation)annotation);
        }));
    }

    public void buildWorld() {
    }

    public void disposeWorld() {
    }

    public Snippet getSnippet() {
        return new JavaSnippet();
    }
}

