/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.backend.CucumberBackendException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class MethodFormat {
    static final MethodFormat FULL = new MethodFormat("%qc.%m(%a) in %s");
    private static final Pattern METHOD_PATTERN = Pattern.compile("((?:static\\s|public\\s)+)([^\\s]*)\\s\\.?(.*)\\.([^\\(]*)\\(([^\\)]*)\\)(?: throws )?(.*)");
    private static final Pattern PACKAGE_PATTERN = Pattern.compile("[^,<>]*\\.");
    private final MessageFormat format;

    private MethodFormat(String format) {
        String pattern = format.replaceAll("%M", "{0}").replaceAll("%r", "{1}").replaceAll("%qc", "{2}").replaceAll("%m", "{3}").replaceAll("%qa", "{4}").replaceAll("%qe", "{5}").replaceAll("%c", "{6}").replaceAll("%a", "{7}").replaceAll("%e", "{8}").replaceAll("%s", "{9}");
        this.format = new MessageFormat(pattern);
    }

    private static String removePackage(String qc) {
        return PACKAGE_PATTERN.matcher(qc).replaceAll("");
    }

    String format(Method method) {
        String signature = method.toGenericString();
        Matcher matcher = METHOD_PATTERN.matcher(signature);
        if (matcher.find()) {
            String M = matcher.group(1);
            String r = matcher.group(2);
            String qc = matcher.group(3);
            String m = matcher.group(4);
            String qa = matcher.group(5);
            String qe = matcher.group(6);
            String c = MethodFormat.removePackage(qc);
            String a2 = MethodFormat.removePackage(qa);
            String e = MethodFormat.removePackage(qe);
            String s = this.getCodeSource(method);
            return this.format.format(new Object[]{M, r, qc, m, qa, qe, c, a2, e, s});
        }
        throw new CucumberBackendException("Cucumber bug: Couldn't format " + signature);
    }

    private String getCodeSource(Method method) {
        try {
            ProtectionDomain protectionDomain = method.getDeclaringClass().getProtectionDomain();
            return protectionDomain.getCodeSource().getLocation().toExternalForm();
        }
        catch (Exception e) {
            return method.getDeclaringClass().getName();
        }
    }
}

