/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.java;

import io.cucumber.core.backend.DefaultDataTableCellTransformerDefinition;
import io.cucumber.core.backend.Lookup;
import io.cucumber.datatable.TableCellByTypeTransformer;
import io.cucumber.java.AbstractGlueDefinition;
import io.cucumber.java.DefaultDataTableCellTransformer;
import io.cucumber.java.InvalidMethodSignatureException;
import io.cucumber.java.Invoker;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

class JavaDefaultDataTableCellTransformerDefinition
extends AbstractGlueDefinition
implements DefaultDataTableCellTransformerDefinition {
    private final TableCellByTypeTransformer transformer = this::execute;

    JavaDefaultDataTableCellTransformerDefinition(Method method, Lookup lookup) {
        super(JavaDefaultDataTableCellTransformerDefinition.requireValidMethod(method), lookup);
    }

    private static Method requireValidMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        if (Void.class.equals(returnType) || Void.TYPE.equals(returnType)) {
            throw JavaDefaultDataTableCellTransformerDefinition.createInvalidSignatureException(method);
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length != 2) {
            throw JavaDefaultDataTableCellTransformerDefinition.createInvalidSignatureException(method);
        }
        if (!Object.class.equals(parameterTypes[0]) && !String.class.equals(parameterTypes[0])) {
            throw JavaDefaultDataTableCellTransformerDefinition.createInvalidSignatureException(method);
        }
        if (!Type.class.equals(parameterTypes[1])) {
            throw JavaDefaultDataTableCellTransformerDefinition.createInvalidSignatureException(method);
        }
        return method;
    }

    private static InvalidMethodSignatureException createInvalidSignatureException(Method method) {
        return InvalidMethodSignatureException.builder(method).addAnnotation(DefaultDataTableCellTransformer.class).addSignature("public Object defaultDataTableCell(String fromValue, Type toValueType)").addSignature("public Object defaultDataTableCell(Object fromValue, Type toValueType)").build();
    }

    public TableCellByTypeTransformer tableCellByTypeTransformer() {
        return this.transformer;
    }

    private Object execute(String fromValue, Type toValueType) {
        return Invoker.invoke(this, this.lookup.getInstance(this.method.getDeclaringClass()), this.method, fromValue, toValueType);
    }
}

