/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.java;

import cucumber.api.Scenario;
import cucumber.api.java.ObjectFactory;
import cucumber.runtime.CucumberException;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.MethodFormat;
import cucumber.runtime.Utils;
import cucumber.runtime.filter.TagPredicate;
import gherkin.pickles.PickleTag;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;

public class JavaHookDefinition
implements HookDefinition {
    private final Method method;
    private final long timeoutMillis;
    private final TagPredicate tagPredicate;
    private final int order;
    private final ObjectFactory objectFactory;

    JavaHookDefinition(Method method, String[] tagExpressions, int order, long timeoutMillis, ObjectFactory objectFactory) {
        this.method = method;
        this.timeoutMillis = timeoutMillis;
        this.tagPredicate = new TagPredicate(Arrays.asList(tagExpressions));
        this.order = order;
        this.objectFactory = objectFactory;
    }

    Method getMethod() {
        return this.method;
    }

    public String getLocation(boolean detail) {
        MethodFormat format = detail ? MethodFormat.FULL : MethodFormat.SHORT;
        return format.format(this.method);
    }

    public void execute(Scenario scenario) throws Throwable {
        Object[] args;
        switch (this.method.getParameterTypes().length) {
            case 0: {
                args = new Object[]{};
                break;
            }
            case 1: {
                if (!Scenario.class.equals(this.method.getParameterTypes()[0])) {
                    throw new CucumberException("When a hook declares an argument it must be of type " + Scenario.class.getName() + ". " + this.method.toString());
                }
                args = new Object[]{scenario};
                break;
            }
            default: {
                throw new CucumberException("Hooks must declare 0 or 1 arguments. " + this.method.toString());
            }
        }
        Utils.invoke(this.objectFactory.getInstance(this.method.getDeclaringClass()), (Method)this.method, (long)this.timeoutMillis, (Object[])args);
    }

    public boolean matches(Collection<PickleTag> tags) {
        return this.tagPredicate.apply(tags);
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isScenarioScoped() {
        return false;
    }
}

