/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import android.util.Log;
import cucumber.api.PickleStepTestStep;
import cucumber.api.event.ConcurrentEventListener;
import cucumber.api.event.EventHandler;
import cucumber.api.event.EventPublisher;
import cucumber.api.event.TestCaseStarted;
import cucumber.api.event.TestRunFinished;
import cucumber.api.event.TestStepStarted;
import cucumber.runtime.UndefinedStepsTracker;
import cucumber.runtime.formatter.Stats;

public final class AndroidLogcatReporter
implements ConcurrentEventListener {
    private final String logTag;
    private final EventHandler<TestCaseStarted> testCaseStartedHandler = new EventHandler<TestCaseStarted>(){

        public void receive(TestCaseStarted event) {
            Log.d((String)AndroidLogcatReporter.this.logTag, (String)String.format("%s", event.testCase.getName()));
        }
    };
    private final Stats stats;
    private final UndefinedStepsTracker undefinedStepsTracker;
    private final EventHandler<TestStepStarted> testStepStartedHandler = new EventHandler<TestStepStarted>(){

        public void receive(TestStepStarted event) {
            if (event.testStep instanceof PickleStepTestStep) {
                PickleStepTestStep testStep = (PickleStepTestStep)event.testStep;
                Log.d((String)AndroidLogcatReporter.this.logTag, (String)String.format("%s", testStep.getStepText()));
            }
        }
    };
    private EventHandler<TestRunFinished> runFinishHandler = new EventHandler<TestRunFinished>(){

        public void receive(TestRunFinished event) {
            for (Throwable throwable : AndroidLogcatReporter.this.stats.getErrors()) {
                Log.e((String)AndroidLogcatReporter.this.logTag, (String)throwable.toString());
            }
            for (String snippet : AndroidLogcatReporter.this.undefinedStepsTracker.getSnippets()) {
                Log.w((String)AndroidLogcatReporter.this.logTag, (String)snippet);
            }
        }
    };

    public AndroidLogcatReporter(Stats stats, UndefinedStepsTracker undefinedStepsTracker, String logTag) {
        this.stats = stats;
        this.undefinedStepsTracker = undefinedStepsTracker;
        this.logTag = logTag;
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestCaseStarted.class, this.testCaseStartedHandler);
        publisher.registerHandlerFor(TestStepStarted.class, this.testStepStartedHandler);
        publisher.registerHandlerFor(TestRunFinished.class, this.runFinishHandler);
    }
}

