/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.android;

import android.os.Bundle;

public class Arguments {
    private static final String VALUE_SEPARATOR = "--";
    private final boolean countEnabled;
    private final boolean debugEnabled;
    private final boolean coverageEnabled;
    private final String coverageDataFilePath;
    private final String cucumberOptions;

    public Arguments(Bundle bundle) {
        this.countEnabled = this.getBooleanArgument(bundle, "count");
        this.debugEnabled = this.getBooleanArgument(bundle, "debug");
        this.coverageEnabled = this.getBooleanArgument(bundle, "coverage");
        this.coverageDataFilePath = this.getStringArgument(bundle, "coverageFile", "coverage.ec");
        this.cucumberOptions = this.getCucumberOptionsString(bundle);
    }

    public boolean isCountEnabled() {
        return this.countEnabled;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public String coverageDataFilePath() {
        return this.coverageDataFilePath;
    }

    public boolean isCoverageEnabled() {
        return this.coverageEnabled;
    }

    public String getCucumberOptions() {
        return this.cucumberOptions;
    }

    private boolean getBooleanArgument(Bundle bundle, String key) {
        if (bundle == null) {
            return false;
        }
        String tagString = bundle.getString(key);
        return tagString != null && Boolean.parseBoolean(tagString);
    }

    private String getStringArgument(Bundle bundle, String key, String defaultValue) {
        if (bundle == null) {
            return defaultValue;
        }
        return bundle.getString(key, defaultValue);
    }

    private void appendOption(StringBuilder sb, String optionKey, String optionValue) {
        for (String value : optionValue.split(VALUE_SEPARATOR)) {
            sb.append(sb.length() == 0 || optionKey.isEmpty() ? "" : " ").append(optionKey).append(optionValue.isEmpty() ? "" : " " + value);
        }
    }

    private String getCucumberOptionsString(Bundle bundle) {
        if (bundle == null) {
            return "";
        }
        String cucumberOptions = bundle.getString("cucumberOptions");
        if (cucumberOptions != null) {
            return cucumberOptions;
        }
        StringBuilder sb = new StringBuilder();
        String features = "";
        for (String key : bundle.keySet()) {
            if ("glue".equals(key)) {
                this.appendOption(sb, "--glue", bundle.getString(key));
                continue;
            }
            if ("format".equals(key)) {
                this.appendOption(sb, "--format", bundle.getString(key));
                continue;
            }
            if ("plugin".equals(key)) {
                this.appendOption(sb, "--plugin", bundle.getString(key));
                continue;
            }
            if ("tags".equals(key)) {
                this.appendOption(sb, "--tags", bundle.getString(key));
                continue;
            }
            if ("name".equals(key)) {
                this.appendOption(sb, "--name", bundle.getString(key));
                continue;
            }
            if ("dryRun".equals(key) && this.getBooleanArgument(bundle, key)) {
                this.appendOption(sb, "--dry-run", "");
                continue;
            }
            if ("log".equals(key) && this.getBooleanArgument(bundle, key)) {
                this.appendOption(sb, "--dry-run", "");
                continue;
            }
            if ("noDryRun".equals(key) && this.getBooleanArgument(bundle, key)) {
                this.appendOption(sb, "--no-dry-run", "");
                continue;
            }
            if ("monochrome".equals(key) && this.getBooleanArgument(bundle, key)) {
                this.appendOption(sb, "--monochrome", "");
                continue;
            }
            if ("noMonochrome".equals(key) && this.getBooleanArgument(bundle, key)) {
                this.appendOption(sb, "--no-monochrome", "");
                continue;
            }
            if ("strict".equals(key) && this.getBooleanArgument(bundle, key)) {
                this.appendOption(sb, "--strict", "");
                continue;
            }
            if ("noStrict".equals(key) && this.getBooleanArgument(bundle, key)) {
                this.appendOption(sb, "--no-strict", "");
                continue;
            }
            if ("snippets".equals(key)) {
                this.appendOption(sb, "--snippets", bundle.getString(key));
                continue;
            }
            if (!"features".equals(key)) continue;
            features = bundle.getString(key);
        }
        this.appendOption(sb, "", features);
        return sb.toString();
    }

    static class DEFAULT {
        static final String COVERAGE_DATA_FILE_PATH = "coverage.ec";

        DEFAULT() {
        }
    }

    static class KEY {
        static final String COUNT_ENABLED = "count";
        static final String DEBUG_ENABLED = "debug";
        static final String COVERAGE_ENABLED = "coverage";
        static final String COVERAGE_DATA_FILE_PATH = "coverageFile";

        KEY() {
        }
    }
}

