/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.naming;

import io.continual.util.naming.Name;
import java.util.ArrayList;
import java.util.List;

public class Path
implements Comparable<Path> {
    private final Path fParent;
    private final Name fName;
    private static final char kSepChar = '/';
    private static final String kSepStr = "/";

    public static Path fromString(String path) {
        return new Path(path);
    }

    public static Path getRootPath() {
        return Path.fromString(kSepStr);
    }

    public String getId() {
        return this.toString();
    }

    @Override
    public int compareTo(Path o) {
        return this.toString().compareTo(o.toString());
    }

    public boolean isRootPath() {
        return Path.getRootPath().compareTo(this) == 0;
    }

    public Path getParentPath() {
        return this.fParent;
    }

    public Name getItemName() {
        return this.fName;
    }

    public boolean startsWith(String text) {
        return this.toString().startsWith(text);
    }

    public boolean startsWith(Path parentPath) {
        if (parentPath.equals(this)) {
            return true;
        }
        Path parent = this.getParentPath();
        return parent != null && parent.startsWith(parentPath);
    }

    public Path makeChildItem(Name name) {
        return new Path(this, name);
    }

    public Path makeChildPath(Path childPath) {
        StringBuilder sb = new StringBuilder().append(this.toString()).append(childPath.toString());
        return Path.fromString(sb.toString());
    }

    public Path makePathWithinParent(Path parentPath) {
        if (parentPath.isRootPath()) {
            return this;
        }
        if (!this.startsWith(parentPath)) {
            throw new IllegalArgumentException("The target path [" + this.toString() + "] is not a child of [" + parentPath.toString() + "].");
        }
        String substr = this.toString().substring(parentPath.toString().length());
        return substr.length() == 0 ? Path.getRootPath() : Path.fromString(substr);
    }

    public Name[] getSegments() {
        List<Name> segments = this.getSegmentList();
        return segments.toArray(new Name[segments.size()]);
    }

    public List<Name> getSegmentList() {
        ArrayList<Name> segments;
        List<Object> list = segments = this.fParent == null ? new ArrayList() : this.fParent.getSegmentList();
        if (this.fName != null) {
            segments.add(this.fName);
        }
        return segments;
    }

    public int depth() {
        Path parent = this.getParentPath();
        if (parent == null) {
            return 1;
        }
        return 1 + parent.depth();
    }

    public String toString() {
        if (this.fParent == null && this.fName == null) {
            return kSepStr;
        }
        String parentPart = this.fParent == null ? "" : this.fParent.toString();
        StringBuilder sb = new StringBuilder();
        sb.append(parentPart);
        if (!parentPart.endsWith(kSepStr)) {
            sb.append(kSepStr);
        }
        sb.append(this.fName == null ? "" : this.fName.toString());
        return sb.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Path other = (Path)obj;
        return this.toString().equals(other.toString());
    }

    private Path(String path) {
        if (path == null || !path.startsWith(kSepStr)) {
            throw new IllegalArgumentException("Path string must be absolute.");
        }
        while (path.contains("//") || path.contains("/./")) {
            path = path.replaceAll("//", kSepStr).replaceAll("/\\./", kSepStr);
        }
        while (path.endsWith("/.")) {
            path = path.substring(0, path.length() - 2);
        }
        if (path.length() == 0 || path.equals(kSepStr)) {
            this.fParent = null;
            this.fName = null;
            return;
        }
        int lastSlash = path.lastIndexOf(47);
        if (lastSlash == 0) {
            this.fParent = Path.getRootPath();
            this.fName = Path.buildName(path.substring(1));
        } else {
            String parentPart = path.substring(0, lastSlash);
            String namePart = path.substring(lastSlash + 1);
            this.fParent = new Path(parentPart);
            this.fName = Path.buildName(namePart);
        }
    }

    private Path(Path path, Name child) {
        this.fParent = path;
        this.fName = child;
    }

    private static Name buildName(String name) {
        if (name.equals("..")) {
            throw new IllegalArgumentException("Path components may not contain '..'.");
        }
        return Name.fromString(name);
    }
}

