/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.console;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import jline.console.ConsoleReader;
import org.slf4j.LoggerFactory;

public class ConsoleLineReader {
    private static final reader sfReader;

    public static String getLine(String prompt) throws IOException {
        return sfReader.getLine(prompt);
    }

    static {
        ConsoleReader cr = null;
        if (Boolean.parseBoolean(System.getProperty("rrJline", "true"))) {
            try {
                cr = new ConsoleReader();
            }
            catch (IOException e) {
                LoggerFactory.getLogger(ConsoleLineReader.class).warn("IOException initializing JLine. Falling back to standard Java I/O.");
                cr = null;
            }
        }
        if (cr != null) {
            final ConsoleReader crf = cr;
            sfReader = new reader(){

                @Override
                public String getLine(String prompt) throws IOException {
                    return crf.readLine(prompt);
                }
            };
        } else {
            final BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            sfReader = new reader(){

                @Override
                public String getLine(String prompt) throws IOException {
                    System.out.print(prompt);
                    System.out.flush();
                    return br.readLine();
                }
            };
        }
    }

    private static interface reader {
        public String getLine(String var1) throws IOException;
    }
}

