/*
 * Decompiled with CFR 0.152.
 */
package io.continual.util.data.json;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonObjectMap
implements Map<String, String> {
    private final JSONObject fObject;

    public JsonObjectMap(JSONObject o) {
        this.fObject = o;
    }

    @Override
    public int size() {
        return this.fObject.length();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.fObject.has(key.toString());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public String get(Object key) {
        return this.fObject.optString(key.toString());
    }

    @Override
    public String put(String key, String value) {
        String was = this.fObject.optString(key);
        this.fObject.put(key, (Object)value);
        return was;
    }

    @Override
    public String remove(Object key) {
        String was = this.fObject.optString(key.toString());
        this.fObject.remove(key.toString());
        return was;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        for (Map.Entry<? extends String, ? extends String> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public void clear() {
        for (Object key : this.fObject.keySet()) {
            this.fObject.remove(key.toString());
        }
    }

    @Override
    public Set<String> keySet() {
        TreeSet<String> set = new TreeSet<String>();
        for (Map.Entry<String, String> e : this.entrySet()) {
            set.add(e.getKey());
        }
        return set;
    }

    @Override
    public Collection<String> values() {
        TreeSet<String> set = new TreeSet<String>();
        for (Map.Entry<String, String> e : this.entrySet()) {
            set.add(e.getValue());
        }
        return set;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        TreeSet<Map.Entry<String, String>> result = new TreeSet<Map.Entry<String, String>>();
        try {
            JSONArray names = this.fObject.names();
            for (int i = 0; i < names.length(); ++i) {
                String key = names.getString(i);
                Object val = this.fObject.opt(key);
                if (val == null) continue;
                result.add(new entry(key, val.toString()));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private static class entry
    implements Map.Entry<String, String> {
        private final String fK;
        private final String fV;

        public entry(String k, String v) {
            this.fK = k;
            this.fV = v;
        }

        @Override
        public String getKey() {
            return this.fK;
        }

        @Override
        public String getValue() {
            return this.fV;
        }

        @Override
        public String setValue(String value) {
            return null;
        }
    }
}

