/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.impl.common;

import io.continual.iam.exceptions.IamBadRequestException;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.ApiKey;
import io.continual.iam.identity.Group;
import io.continual.iam.identity.Identity;
import io.continual.iam.impl.common.CommonJsonDb;
import io.continual.iam.impl.common.CommonJsonObject;
import io.continual.util.data.OneWayHasher;
import io.continual.util.data.json.JsonUtil;
import io.continual.util.data.json.JsonVisitor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonJsonIdentity
extends CommonJsonObject
implements Identity {
    private final String fUserId;
    private final CommonJsonDb<? extends CommonJsonIdentity, ?> fDb;
    private JSONObject fUserRecord;
    private String fApiKey = null;
    private static final Logger log = LoggerFactory.getLogger(CommonJsonIdentity.class);

    public static JSONObject initializeIdentity() {
        return new JSONObject().put("enabled", true);
    }

    public CommonJsonIdentity(String userId, JSONObject userRecord, CommonJsonDb<? extends CommonJsonIdentity, ?> db) {
        this.fDb = db;
        this.fUserId = userId;
        this.fUserRecord = userRecord;
    }

    @Override
    public String getId() {
        return this.fUserId;
    }

    public String toString() {
        return this.fApiKey == null ? this.getId() : this.getId() + " (" + this.fApiKey + ")";
    }

    public void setApiKeyUsedForAuth(String apiKey) {
        this.fApiKey = apiKey;
    }

    public String getApiKey() {
        return this.fApiKey;
    }

    public JSONObject asJson() {
        return this.fUserRecord;
    }

    @Override
    public void setPassword(String password) throws IamSvcException {
        String salt = CommonJsonIdentity.generateSalt(this.fDb.getAppNonce());
        String hash = CommonJsonIdentity.generateHash(password, salt);
        this.setPasswordSaltAndHash(salt, hash);
    }

    public void setPasswordSaltAndHash(String salt, String hash) throws IamSvcException {
        JSONObject o = new JSONObject().put("salt", (Object)salt).put("hash", (Object)hash);
        this.fUserRecord.put("password", (Object)o);
        this.fDb.storeUserObject(this.getId(), this.asJson());
    }

    @Override
    public String requestPasswordReset(long secondsUntilExpire, String nonce) throws IamSvcException, IamBadRequestException {
        if (!this.isEnabled()) {
            throw new IamBadRequestException(this.getId() + " is disabled.");
        }
        return this.fDb.createTag(this.getId(), "passwordReset", secondsUntilExpire, TimeUnit.SECONDS, nonce);
    }

    @Override
    public ApiKey createApiKey() throws IamSvcException {
        try {
            return this.fDb.createApiKey(this.getId());
        }
        catch (IamBadRequestException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new IamSvcException(e);
        }
    }

    @Override
    public Collection<String> loadApiKeysForUser() throws IamSvcException {
        try {
            return this.fDb.loadApiKeysForUser(this.getId());
        }
        catch (IamBadRequestException e) {
            log.warn(e.getMessage(), (Throwable)e);
            throw new IamSvcException(e);
        }
    }

    @Override
    public void deleteApiKey(ApiKey key) throws IamSvcException {
        this.fDb.deleteApiKeyObject(key.getKey());
    }

    @Override
    public void enable(boolean enable) throws IamSvcException {
        this.fUserRecord.put("enabled", enable);
        this.fDb.storeUserObject(this.getId(), this.asJson());
    }

    @Override
    public boolean isEnabled() {
        return this.fUserRecord.optBoolean("enabled", false);
    }

    public String getPasswordSalt() {
        JSONObject pwd = this.fUserRecord.optJSONObject("password");
        if (pwd != null) {
            return pwd.optString("salt", null);
        }
        return null;
    }

    public String getPasswordHash() {
        JSONObject pwd = this.fUserRecord.optJSONObject("password");
        if (pwd != null) {
            return pwd.optString("hash", null);
        }
        return null;
    }

    @Override
    public Set<String> getGroupIds() throws IamSvcException {
        final TreeSet<String> result = new TreeSet<String>();
        JsonVisitor.forEachElement((JSONArray)this.fUserRecord.optJSONArray("groups"), (JsonVisitor.ArrayVisitor)new JsonVisitor.ArrayVisitor<String, IamSvcException>(){

            public boolean visit(String groupId) throws IamSvcException {
                result.add(groupId);
                return true;
            }
        });
        return result;
    }

    @Override
    public Collection<Group> getGroups() throws IamSvcException {
        LinkedList<Group> result = new LinkedList<Group>();
        for (String groupId : this.getGroupIds()) {
            try {
                Group g = this.fDb.loadGroup(groupId);
                if (g == null) continue;
                result.add(g);
            }
            catch (JSONException e) {
                log.warn("Error loading group [" + groupId + "]", (Throwable)e);
            }
        }
        return result;
    }

    @Override
    public Group getGroup(String groupId) throws IamSvcException {
        if (this.getGroupIds().contains(groupId)) {
            return this.fDb.loadGroup(groupId);
        }
        return null;
    }

    public void addApiKey(String newApiKey) {
        JSONArray a = this.fUserRecord.optJSONArray("apiKeys");
        if (a == null) {
            a = new JSONArray();
            this.fUserRecord.put("apiKeys", (Object)a);
        }
        a.put((Object)newApiKey);
    }

    protected boolean addGroup(String groupId) {
        JSONArray groups = this.fUserRecord.optJSONArray("groups");
        if (groups == null) {
            groups = new JSONArray();
            this.fUserRecord.put("groups", (Object)groups);
        }
        return JsonUtil.ensureStringInArray((String)groupId, (JSONArray)groups);
    }

    protected boolean removeGroup(String groupId) {
        return JsonUtil.removeStringFromArray((JSONArray)this.fUserRecord.optJSONArray("groups"), (String)groupId);
    }

    @Override
    protected JSONObject getDataRecord() {
        return this.fUserRecord;
    }

    @Override
    public void reload() throws IamSvcException {
        this.fUserRecord = this.fDb.loadUserObject(this.getId());
    }

    @Override
    protected void store() throws IamSvcException {
        this.fDb.storeUserObject(this.getId(), this.getDataRecord());
    }

    private static String generateSalt(String appNonce) {
        return CommonJsonDb.generateKey(64, appNonce);
    }

    private static String generateHash(String pwd, String salt) {
        return OneWayHasher.pbkdf2HashToString((String)pwd, (String)salt);
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: CommonJsonIdentity <password>");
            return;
        }
        String salt = CommonJsonIdentity.generateSalt(null);
        String hash = CommonJsonIdentity.generateHash(args[0], salt);
        System.out.println(new JSONObject().put("salt", (Object)salt).put("hash", (Object)hash).toString());
    }
}

