/*
 * Decompiled with CFR 0.152.
 */
package io.continual.iam.impl;

import io.continual.builder.Builder;
import io.continual.iam.IamDb;
import io.continual.iam.IamServiceManager;
import io.continual.iam.access.AccessDb;
import io.continual.iam.access.AccessManager;
import io.continual.iam.exceptions.IamSvcException;
import io.continual.iam.identity.Group;
import io.continual.iam.identity.Identity;
import io.continual.iam.identity.IdentityDb;
import io.continual.iam.identity.IdentityManager;
import io.continual.iam.tags.TagManager;
import io.continual.metrics.MetricsCatalog;
import io.continual.metrics.MetricsSupplier;
import io.continual.services.Service;
import io.continual.services.ServiceContainer;
import io.continual.services.SimpleService;
import org.json.JSONObject;

public class BasicIamServiceWrapper<I extends Identity, G extends Group>
extends SimpleService
implements IamServiceManager<I, G>,
Service,
MetricsSupplier {
    private final IamDb<I, G> fDb;

    public BasicIamServiceWrapper(ServiceContainer sc, JSONObject config) throws IamSvcException, Builder.BuildFailure {
        this.fDb = (IamDb)Builder.withBaseClass(IamDb.class).withClassNameInData().providingContext((Object)sc).usingData(config.getJSONObject("db")).build();
    }

    protected void onStartRequested() throws Service.FailedToStart {
        try {
            this.fDb.start();
        }
        catch (IamSvcException e) {
            throw new Service.FailedToStart((Throwable)e);
        }
    }

    protected void onStopRequested() {
        this.fDb.close();
    }

    public void populateMetrics(MetricsCatalog metrics) {
        this.fDb.populateMetrics(metrics);
    }

    @Override
    public IdentityDb<I> getIdentityDb() throws IamSvcException {
        return this.fDb;
    }

    @Override
    public AccessDb<G> getAccessDb() throws IamSvcException {
        return this.fDb;
    }

    @Override
    public IdentityManager<I> getIdentityManager() throws IamSvcException {
        return this.fDb;
    }

    @Override
    public AccessManager<G> getAccessManager() throws IamSvcException {
        return this.fDb;
    }

    @Override
    public TagManager getTagManager() throws IamSvcException {
        return this.fDb;
    }
}

