/*
 * Decompiled with CFR 0.152.
 */
package io.continual.shaded.com.rabbitmq.tools.jsonrpc;

import io.continual.shaded.com.rabbitmq.tools.json.JSONUtil;
import io.continual.shaded.com.rabbitmq.tools.jsonrpc.ProcedureDescription;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class ServiceDescription {
    public static final String JSON_RPC_VERSION = "1.1";
    public String name;
    public String id;
    public String version;
    public String summary;
    public String help;
    private Map<String, ProcedureDescription> procedures;

    public ServiceDescription(Map<String, Object> rawServiceDescription) {
        JSONUtil.tryFill(this, rawServiceDescription);
    }

    public ServiceDescription(Class<?> klass) {
        this.procedures = new HashMap<String, ProcedureDescription>();
        for (Method m : klass.getMethods()) {
            ProcedureDescription proc = new ProcedureDescription(m);
            this.addProcedure(proc);
        }
    }

    public ServiceDescription() {
    }

    public Collection<ProcedureDescription> getProcs() {
        return this.procedures.values();
    }

    public void setProcs(Collection<Map<String, Object>> p) {
        this.procedures = new HashMap<String, ProcedureDescription>();
        for (Map<String, Object> pm : p) {
            ProcedureDescription proc = new ProcedureDescription(pm);
            this.addProcedure(proc);
        }
    }

    private void addProcedure(ProcedureDescription proc) {
        this.procedures.put(proc.name + "/" + proc.arity(), proc);
    }

    public ProcedureDescription getProcedure(String newname, int arity) {
        ProcedureDescription proc = this.procedures.get(newname + "/" + arity);
        if (proc == null) {
            throw new IllegalArgumentException("Procedure not found: " + newname + ", arity " + arity);
        }
        return proc;
    }
}

