/*
 * Decompiled with CFR 0.152.
 */
package io.continual.shaded.com.rabbitmq.client.impl;

import io.continual.shaded.com.rabbitmq.client.Command;
import io.continual.shaded.com.rabbitmq.client.Method;
import io.continual.shaded.com.rabbitmq.client.ShutdownSignalException;
import io.continual.shaded.com.rabbitmq.client.impl.AMQChannel;
import io.continual.shaded.com.rabbitmq.client.impl.AMQCommand;
import io.continual.shaded.com.rabbitmq.client.impl.RpcWrapper;
import java.util.concurrent.CompletableFuture;

public class CompletableFutureRpcWrapper
implements RpcWrapper {
    private final Method request;
    private final CompletableFuture<Command> completableFuture;

    public CompletableFutureRpcWrapper(Method method, CompletableFuture<Command> completableFuture) {
        this.request = method;
        this.completableFuture = completableFuture;
    }

    @Override
    public boolean canHandleReply(AMQCommand command) {
        return AMQChannel.SimpleBlockingRpcContinuation.isResponseCompatibleWithRequest(this.request, command.getMethod());
    }

    @Override
    public void complete(AMQCommand command) {
        this.completableFuture.complete(command);
    }

    @Override
    public void shutdown(ShutdownSignalException signal) {
        this.completableFuture.completeExceptionally(signal);
    }
}

