/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.library.services;

import io.continual.services.ServiceContainer;
import io.continual.services.processor.service.SimpleProcessingService;
import io.continual.util.data.json.CommentedJsonTokener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.json.JSONObject;
import org.json.JSONTokener;

public class SimpleKeyStore
extends SimpleProcessingService {
    private final File fStorage;
    private JSONObject fData;

    public SimpleKeyStore(ServiceContainer sc, JSONObject config) {
        this(new File(config.getString("file")));
    }

    public SimpleKeyStore(File storage) {
        this.fStorage = storage;
        this.readStorage();
    }

    public String getString(String key, String defval) {
        return this.fData.optString(key, defval);
    }

    public void put(String key, String val) {
        this.fData.put(key, (Object)val);
        this.writeStorage();
    }

    public long getLong(String key, long defval) {
        return this.fData.optLong(key, defval);
    }

    public void put(String key, long val) {
        this.fData.put(key, val);
        this.writeStorage();
    }

    private void readStorage() {
        try (FileInputStream fis = new FileInputStream(this.fStorage);){
            this.fData = new JSONObject((JSONTokener)new CommentedJsonTokener((InputStream)fis));
        }
        catch (IOException x) {
            this.fData = new JSONObject();
        }
    }

    private void writeStorage() {
        try (FileOutputStream fos = new FileOutputStream(this.fStorage);){
            fos.write(this.fData.toString().getBytes());
        }
        catch (IOException x) {
            this.fData = new JSONObject();
        }
    }
}

