/*
 * Decompiled with CFR 0.152.
 */
package io.continual.services.processor.engine.runtime;

import io.continual.services.Service;
import io.continual.services.processor.config.readers.ConfigReadException;
import io.continual.services.processor.config.readers.JsonConfigReader;
import io.continual.services.processor.engine.model.Program;
import io.continual.services.processor.engine.runtime.Engine;
import io.continual.util.console.ConsoleProgram;

public class ProgramRunner
extends ConsoleProgram {
    public static void runProgram(String[] programList) {
        try {
            JsonConfigReader reader = new JsonConfigReader();
            Program program = reader.read(programList[0].split(","));
            Engine e = new Engine(program);
            for (int i = 1; i < programList.length; ++i) {
                e.setUserData("" + i, programList[i]);
            }
            e.startAndWait();
        }
        catch (ConfigReadException e) {
            System.err.println(e.getMessage());
        }
        catch (Service.FailedToStart e) {
            System.err.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.err.println("usage: ProgramRunner <program>");
            return;
        }
        ProgramRunner.runProgram(args);
    }
}

